<?php
$basePath = '/Applications/XAMPP/xamppfiles/htdocs/lead-management';

echo "<h1>Fixing Directory Structure</h1>";

// Fix 1: Rename Resourses to resources
$wrongPath = $basePath . '/Resourses';
$correctPath = $basePath . '/resources';

if (is_dir($wrongPath) && !is_dir($correctPath)) {
    if (rename($wrongPath, $correctPath)) {
        echo "✅ Renamed 'Resourses' to 'resources'<br>";
    } else {
        echo "❌ Failed to rename Resourses to resources<br>";
    }
} elseif (is_dir($correctPath)) {
    echo "✓ resources directory already exists<br>";
}

// Fix 2: Move files from wrong locations
$filesToMove = [
    $basePath . '/Models/form.php' => $basePath . '/app/Models/Form.php',
    $basePath . '/Services/LeadService.php' => $basePath . '/app/Services/LeadService.php',
];

foreach ($filesToMove as $wrongLocation => $correctLocation) {
    if (file_exists($wrongLocation) && !file_exists($correctLocation)) {
        if (rename($wrongLocation, $correctLocation)) {
            echo "✅ Moved: " . basename($wrongLocation) . " to correct location<br>";
        } else {
            echo "❌ Failed to move: " . basename($wrongLocation) . "<br>";
        }
    }
}

// Fix 3: Create missing directories
$directories = [
    $basePath . '/public/assets/css',
    $basePath . '/public/assets/js',
    $basePath . '/storage/uploads',
    $basePath . '/storage/logs',
    $basePath . '/storage/cache',
];

foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        if (mkdir($dir, 0755, true)) {
            echo "✅ Created: " . str_replace($basePath, '', $dir) . "<br>";
        } else {
            echo "❌ Failed to create: " . str_replace($basePath, '', $dir) . "<br>";
        }
    } else {
        echo "✓ Already exists: " . str_replace($basePath, '', $dir) . "<br>";
    }
}

// Fix 4: Create basic CSS file
$cssContent = '/* Basic Airunner CSS */
body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 20px;
    background: #f5f5f5;
}

.app-container {
    display: flex;
    min-height: 100vh;
}

.sidebar {
    width: 250px;
    background: #1f2937;
    color: white;
    padding: 1rem;
}

.main-content {
    flex: 1;
    padding: 2rem;
}

.card {
    background: white;
    padding: 1.5rem;
    border-radius: 0.5rem;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    margin-bottom: 1rem;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
    margin: 2rem 0;
}

.stat-card {
    background: white;
    padding: 1.5rem;
    border-radius: 0.5rem;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

.btn {
    padding: 0.5rem 1rem;
    background: #3b82f6;
    color: white;
    border: none;
    border-radius: 0.375rem;
    cursor: pointer;
}

.btn:hover {
    background: #2563eb;
}';

$cssFile = $basePath . '/public/assets/css/app.css';
if (file_put_contents($cssFile, $cssContent)) {
    echo "✅ Created CSS file<br>";
} else {
    echo "❌ Failed to create CSS file<br>";
}

// Fix 5: Create basic JS file
$jsContent = '// Airunner JavaScript
console.log("Airunner loaded successfully!");';

$jsFile = $basePath . '/public/assets/js/app.js';
if (file_put_contents($jsFile, $jsContent)) {
    echo "✅ Created JS file<br>";
} else {
    echo "❌ Failed to create JS file<br>";
}

echo "<h2>✅ Structure fix complete!</h2>";
echo '<p><a href="/lead-management/public/">Test Dashboard</a></p>';

// Show final structure
echo "<h3>Final Structure:</h3>";
echo "<pre>";
system("find " . escapeshellarg($basePath) . " -type d | head -20");
echo "</pre>";