<?php
// Debug: Check what files actually exist
echo "<h1>File Structure Debug</h1>";

$basePath = '/Applications/XAMPP/xamppfiles/htdocs/lead-management';

$pathsToCheck = [
    'APP_ROOT' => $basePath,
    'Resources dir exists' => $basePath . '/resources',
    'Views dir exists' => $basePath . '/resources/views',
    'Layouts dir exists' => $basePath . '/resources/views/layouts',
    'Main layout exists' => $basePath . '/resources/views/layouts/main.php',
    'Pages dir exists' => $basePath . '/resources/views/pages',
    'Dashboard page exists' => $basePath . '/resources/views/pages/dashboard.php',
];

echo "<table border='1' style='border-collapse: collapse;'>";
echo "<tr><th>Path</th><th>Exists</th><th>Full Path</th></tr>";

foreach ($pathsToCheck as $label => $path) {
    $exists = file_exists($path) ? '✅ YES' : '❌ NO';
    echo "<tr>";
    echo "<td><strong>$label</strong></td>";
    echo "<td>$exists</td>";
    echo "<td>$path</td>";
    echo "</tr>";
}

echo "</table>";

// Show current directory structure
echo "<h2>Current Directory Structure:</h2>";
echo "<pre>";
system("find " . escapeshellarg($basePath) . " -type f -name '*.php' | head -20");
echo "</pre>";