// ====== Main JavaScript Import File ======

// Configuration
import "./config/constants.js";
import { appSettings } from "./config/settings.js";

// Core functionality
import {
  debounce,
  throttle,
  formatDate,
  formatCurrency,
  generateId,
  copyToClipboard,
} from "./core/utils.js";
import {
  domReady,
  $,
  $$,
  createElement,
  showNotification,
  setLoadingState,
} from "./core/helpers.js";
import { authManager } from "./core/auth.js";
import { apiClient } from "./core/api.js";

// Modules
import { uiManager } from "./modules/ui.js";
import { formManager } from "./modules/forms.js";
import { validation } from "./modules/validation.js";
import { mobileManager } from "./modules/mobile.js";

// Components
import { headerManager } from "./components/header.js";
import { footerManager } from "./components/footer.js";
import { modalManager } from "./components/modals.js";

// Initialize application when DOM is ready
domReady(() => {
  console.log("LeadIntelligence AI Application Initialized");

  // Make globals available for debugging (optional)
  if (appSettings.get("debug")) {
    window.app = {
      settings: appSettings,
      auth: authManager,
      api: apiClient,
      ui: uiManager,
      forms: formManager,
      modals: modalManager,
      utils: { debounce, throttle, formatDate, formatCurrency },
    };
  }
});
// Mobile menu functionality
document.addEventListener("DOMContentLoaded", function () {
  const mobileMenuBtn = document.getElementById("mobileMenuBtn");
  const mobileMenu = document.getElementById("mobileMenu");

  if (mobileMenuBtn && mobileMenu) {
    mobileMenuBtn.addEventListener("click", function (e) {
      e.stopPropagation();
      mobileMenu.classList.toggle("active");
    });

    // Close menu when clicking outside
    document.addEventListener("click", function (event) {
      if (
        !mobileMenu.contains(event.target) &&
        !mobileMenuBtn.contains(event.target)
      ) {
        mobileMenu.classList.remove("active");
      }
    });

    // Close menu when clicking on links
    const mobileLinks = mobileMenu.querySelectorAll(".mobile-nav-link");
    mobileLinks.forEach((link) => {
      link.addEventListener("click", () => {
        mobileMenu.classList.remove("active");
      });
    });
  }
});
// Export for use in other modules
export {
  // Core
  appSettings,
  authManager,
  apiClient,

  // Utils
  debounce,
  throttle,
  formatDate,
  formatCurrency,
  generateId,
  copyToClipboard,

  // Helpers
  domReady,
  $,
  $$,
  createElement,
  showNotification,
  setLoadingState,

  // Modules
  uiManager,
  formManager,
  validation,
  mobileManager,

  // Components
  headerManager,
  footerManager,
  modalManager,
};
