<?php
class DashboardController extends BaseController {
    public function index() {
        $this->checkAuth();
        
        $tenant_id = auth_tenant();
        
        // Get stats
        $stats = [];
        
        $stmt = $this->db->prepare("SELECT COUNT(*) as total FROM leads WHERE tenant_id = ?");
        $stmt->execute([$tenant_id]);
        $stats['total_leads'] = $stmt->fetchColumn();
        
        $stmt = $this->db->prepare("SELECT COUNT(*) as total FROM forms WHERE tenant_id = ?");
        $stmt->execute([$tenant_id]);
        $stats['total_forms'] = $stmt->fetchColumn();
        
        $stmt = $this->db->prepare("SELECT COUNT(*) as total FROM leads WHERE tenant_id = ? AND DATE(created_at) = CURDATE()");
        $stmt->execute([$tenant_id]);
        $stats['leads_today'] = $stmt->fetchColumn();
        
        $stmt = $this->db->prepare("SELECT COUNT(*) as total FROM leads WHERE tenant_id = ? AND ai_score >= 80");
        $stmt->execute([$tenant_id]);
        $stats['high_score_leads'] = $stmt->fetchColumn();
        
        // Recent leads
        $stmt = $this->db->prepare("
            SELECT l.*, CONCAT(l.first_name, ' ', l.last_name) as full_name, f.name as form_name
            FROM leads l 
            LEFT JOIN forms f ON l.form_id = f.id 
            WHERE l.tenant_id = ? 
            ORDER BY l.created_at DESC 
            LIMIT 5
        ");
        $stmt->execute([$tenant_id]);
        $leads = $stmt->fetchAll();
        
        return $this->view->render('pages/dashboard', [
            'pageTitle' => 'Dashboard',
            'stats' => $stats,
            'leads' => $leads
        ]);
    }
}