<?php
// Resources/views/pages/tasks/index.php

$status   = $filters['status']   ?? 'all';
$priority = $filters['priority'] ?? 'all';
$search   = $filters['search']   ?? '';
?>
<style>
    /* Tasks page local styles (scoped by .tasks-page-root) */
    .tasks-page-root {
        max-width: 1120px;
        margin: 0 auto;
        padding: 24px 24px 40px;
        font-family: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text", sans-serif;
        color: #0f172a;
    }

    .tasks-page-header {
        display: flex;
        align-items: flex-start;
        justify-content: space-between;
        gap: 16px;
        margin-bottom: 24px;
    }

    .tasks-page-title {
        font-size: 1.75rem;
        font-weight: 700;
        margin: 0 0 4px;
    }

    .tasks-page-subtitle {
        margin: 0;
        font-size: 0.95rem;
        color: #64748b;
    }

    .tasks-btn {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        border-radius: 999px;
        border: none;
        padding: 8px 14px;
        font-size: 0.9rem;
        font-weight: 500;
        text-decoration: none;
        cursor: pointer;
        background: #0ea5e9;
        color: #e0f2fe;
        box-shadow: 0 10px 20px rgba(14, 165, 233, 0.25);
        transition: transform 0.1s ease, box-shadow 0.1s ease, background 0.1s ease;
        white-space: nowrap;
    }

    .tasks-btn i {
        font-size: 0.9rem;
    }

    .tasks-btn:hover {
        background: #0284c7;
        transform: translateY(-1px);
        box-shadow: 0 14px 30px rgba(14, 165, 233, 0.35);
    }

    .tasks-btn-secondary {
        background: #e2e8f0;
        color: #0f172a;
        box-shadow: none;
    }

    .tasks-btn-secondary:hover {
        background: #cbd5f5;
        box-shadow: none;
    }

    .tasks-card {
        background: rgba(255, 255, 255, 0.96);
        border-radius: 18px;
        border: 1px solid rgba(148, 163, 184, 0.25);
        box-shadow:
            0 18px 40px rgba(15, 23, 42, 0.08),
            0 0 0 1px rgba(255, 255, 255, 0.6) inset;
        margin-bottom: 20px;
        overflow: hidden;
    }

    .tasks-card-header {
        padding: 16px 18px 8px;
        border-bottom: 1px solid rgba(226, 232, 240, 0.9);
    }

    .tasks-card-title {
        margin: 0;
        font-size: 1.05rem;
        font-weight: 600;
        letter-spacing: 0.01em;
    }

    .tasks-card-subtitle {
        margin: 4px 0 0;
        font-size: 0.85rem;
        color: #64748b;
    }

    .tasks-card-body {
        padding: 16px 18px 18px;
    }

    .tasks-filter-grid {
        display: grid;
        grid-template-columns: repeat(4, minmax(0, 1fr));
        gap: 12px;
        align-items: flex-end;
    }

    @media (max-width: 900px) {
        .tasks-filter-grid {
            grid-template-columns: repeat(2, minmax(0, 1fr));
        }
    }

    @media (max-width: 640px) {
        .tasks-filter-grid {
            grid-template-columns: minmax(0, 1fr);
        }
    }

    .tasks-form-group label {
        display: block;
        font-size: 0.8rem;
        font-weight: 500;
        margin-bottom: 4px;
        color: #64748b;
    }

    .tasks-input,
    .tasks-select {
        width: 100%;
        border-radius: 999px;
        border: 1px solid #cbd5f5;
        padding: 7px 12px;
        font-size: 0.9rem;
        outline: none;
        background: #f8fafc;
        transition: border-color 0.12s ease, box-shadow 0.12s ease, background 0.12s ease;
    }

    .tasks-input:focus,
    .tasks-select:focus {
        border-color: #0ea5e9;
        box-shadow: 0 0 0 1px rgba(14, 165, 233, 0.35);
        background: #ffffff;
    }

    .tasks-filter-actions {
        display: flex;
        gap: 8px;
    }

    .tasks-table-wrapper {
        border-radius: 0 0 18px 18px;
        overflow: hidden;
    }

    table.tasks-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 0.9rem;
    }

    .tasks-table th,
    .tasks-table td {
        padding: 10px 14px;
        text-align: left;
        border-bottom: 1px solid rgba(226, 232, 240, 0.9);
        vertical-align: top;
    }

    .tasks-table th {
        background: #f8fafc;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.06em;
        color: #64748b;
    }

    .tasks-table tr:last-child td {
        border-bottom: none;
    }

    .tasks-link-strong {
        color: #0f172a;
        font-weight: 600;
        text-decoration: none;
    }

    .tasks-link-strong:hover {
        color: #0284c7;
    }

    .tasks-subtext {
        font-size: 0.8rem;
        color: #64748b;
        margin-top: 2px;
    }

    .tasks-status-pill {
        display: inline-flex;
        align-items: center;
        padding: 3px 9px;
        border-radius: 999px;
        font-size: 0.75rem;
        font-weight: 500;
    }

    .tasks-status-pending {
        background: #fef3c7;
        color: #92400e;
    }

    .tasks-status-in_progress {
        background: #dbeafe;
        color: #1d4ed8;
    }

    .tasks-status-completed {
        background: #dcfce7;
        color: #166534;
    }

    .tasks-status-blocked {
        background: #fee2e2;
        color: #b91c1c;
    }

    .tasks-badge-priority {
        display: inline-flex;
        align-items: center;
        padding: 3px 8px;
        border-radius: 999px;
        font-size: 0.75rem;
        font-weight: 500;
    }

    .tasks-badge-priority-low {
        background: #e0f2fe;
        color: #0369a1;
    }

    .tasks-badge-priority-medium {
        background: #e5e7eb;
        color: #374151;
    }

    .tasks-badge-priority-high {
        background: #fee2e2;
        color: #b91c1c;
    }

    .tasks-badge-priority-urgent {
        background: #f97316;
        color: #fffbeb;
    }

    .tasks-actions-cell {
        white-space: nowrap;
        text-align: right;
    }

    .tasks-btn-icon {
        display: inline-flex;
        width: 30px;
        height: 30px;
        align-items: center;
        justify-content: center;
        border-radius: 999px;
        border: none;
        background: transparent;
        color: #64748b;
        cursor: pointer;
        text-decoration: none;
        transition: background 0.12s ease, color 0.12s ease, transform 0.1s ease;
    }

    .tasks-btn-icon:hover {
        background: #e5e7eb;
        color: #0f172a;
        transform: translateY(-1px);
    }

    .tasks-btn-icon-danger:hover {
        background: #fee2e2;
        color: #b91c1c;
    }

    .tasks-empty {
        padding: 28px 20px 30px;
        display: flex;
        align-items: center;
        gap: 16px;
    }

    .tasks-empty-icon {
        width: 42px;
        height: 42px;
        border-radius: 50%;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        background: #eff6ff;
        color: #1d4ed8;
        font-size: 1.1rem;
    }

    .tasks-empty-title {
        font-weight: 600;
        margin: 0 0 4px;
    }

    .tasks-empty-text {
        margin: 0 0 10px;
        font-size: 0.9rem;
        color: #64748b;
    }
</style>

<div class="tasks-page-root">
    <div class="tasks-page-header">
        <div>
            <h1 class="tasks-page-title">Tasks</h1>
            <p class="tasks-page-subtitle">
                Track follow-ups and execution work related to your leads and forms.
            </p>
        </div>
        <div>
            <a href="/lead-management/public/app/tasks/create" class="tasks-btn">
                <i class="fas fa-plus"></i>
                <span>New Task</span>
            </a>
        </div>
    </div>

    <!-- Filters card -->
    <div class="tasks-card">
        <div class="tasks-card-header">
            <h2 class="tasks-card-title">Filters</h2>
            <p class="tasks-card-subtitle">Narrow down tasks by status, priority, or search.</p>
        </div>
        <div class="tasks-card-body">
            <form method="GET" class="tasks-filter-grid">
                <div class="tasks-form-group">
                    <label for="status">Status</label>
                    <select id="status" name="status" class="tasks-select">
                        <option value="all" <?= $status === 'all' ? 'selected' : '' ?>>All</option>
                        <option value="pending" <?= $status === 'pending' ? 'selected' : '' ?>>Pending</option>
                        <option value="in_progress" <?= $status === 'in_progress' ? 'selected' : '' ?>>In progress</option>
                        <option value="completed" <?= $status === 'completed' ? 'selected' : '' ?>>Completed</option>
                        <option value="blocked" <?= $status === 'blocked' ? 'selected' : '' ?>>Blocked</option>
                    </select>
                </div>

                <div class="tasks-form-group">
                    <label for="priority">Priority</label>
                    <select id="priority" name="priority" class="tasks-select">
                        <option value="all" <?= $priority === 'all' ? 'selected' : '' ?>>All</option>
                        <option value="low" <?= $priority === 'low' ? 'selected' : '' ?>>Low</option>
                        <option value="medium" <?= $priority === 'medium' ? 'selected' : '' ?>>Medium</option>
                        <option value="high" <?= $priority === 'high' ? 'selected' : '' ?>>High</option>
                        <option value="urgent" <?= $priority === 'urgent' ? 'selected' : '' ?>>Urgent</option>
                    </select>
                </div>

                <div class="tasks-form-group" style="grid-column: span 2;">
                    <label for="search">Search</label>
                    <input
                        type="text"
                        id="search"
                        name="search"
                        value="<?= htmlspecialchars($search) ?>"
                        class="tasks-input"
                        placeholder="Search by title or description"
                    >
                </div>

                <div class="tasks-form-group" style="grid-column: span 4; text-align: right;">
                    <div class="tasks-filter-actions">
                        <button type="submit" class="tasks-btn-secondary tasks-btn">
                            <i class="fas fa-filter"></i>
                            <span>Apply</span>
                        </button>
                        <a href="/lead-management/public/app/tasks" class="tasks-btn-secondary tasks-btn">
                            Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Tasks list card -->
    <div class="tasks-card">
        <div class="tasks-card-header">
            <h2 class="tasks-card-title">Your Tasks</h2>
            <p class="tasks-card-subtitle">
                Stay on top of follow-ups, internal work, and customer promises.
            </p>
        </div>

        <?php if (empty($tasks)): ?>
            <div class="tasks-card-body">
                <div class="tasks-empty">
                    <div class="tasks-empty-icon">
                        <i class="fas fa-tasks"></i>
                    </div>
                    <div>
                        <p class="tasks-empty-title">No tasks found</p>
                        <p class="tasks-empty-text">
                            Create a task to coordinate follow-ups and internal work.
                        </p>
                        <a href="/lead-management/public/app/tasks/create" class="tasks-btn">
                            <i class="fas fa-plus"></i>
                            <span>New Task</span>
                        </a>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="tasks-table-wrapper">
                <table class="tasks-table">
                    <thead>
                        <tr>
                            <th style="width: 40%;">Task</th>
                            <th>Status</th>
                            <th>Priority</th>
                            <th>Due</th>
                            <th>Updated</th>
                            <th style="width: 70px;"></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($tasks as $task): ?>
                        <?php
                            $statusLabel   = ucfirst(str_replace('_', ' ', $task['status']));
                            $priorityLabel = ucfirst($task['priority']);
                        ?>
                        <tr>
                            <td>
                                <a href="/lead-management/public/app/tasks/<?= (int)$task['id'] ?>"
                                   class="tasks-link-strong">
                                    <?= htmlspecialchars($task['title']) ?>
                                </a>
                                <?php if (!empty($task['description'])): ?>
                                    <div class="tasks-subtext">
                                        <?= htmlspecialchars(mb_strimwidth($task['description'], 0, 80, '…')) ?>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="tasks-status-pill tasks-status-<?= htmlspecialchars($task['status']) ?>">
                                    <?= htmlspecialchars($statusLabel) ?>
                                </span>
                            </td>
                            <td>
                                <span class="tasks-badge-priority tasks-badge-priority-<?= htmlspecialchars($task['priority']) ?>">
                                    <?= htmlspecialchars($priorityLabel) ?>
                                </span>
                            </td>
                            <td>
                                <?php if (!empty($task['due_date'])): ?>
                                    <?= htmlspecialchars(date('M j, Y', strtotime($task['due_date']))) ?>
                                <?php else: ?>
                                    <span class="tasks-subtext">No due date</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if (!empty($task['updated_at'])): ?>
                                    <span class="tasks-subtext">
                                        <?= htmlspecialchars(date('M j, Y H:i', strtotime($task['updated_at']))) ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="tasks-actions-cell">
                                <a href="/lead-management/public/app/tasks/<?= (int)$task['id'] ?>/edit"
                                   class="tasks-btn-icon"
                                   title="Edit task">
                                    <i class="fas fa-pen"></i>
                                </a>
                                <a href="/lead-management/public/app/tasks/<?= (int)$task['id'] ?>/delete"
                                   class="tasks-btn-icon tasks-btn-icon-danger"
                                   onclick="return confirm('Delete this task?');"
                                   title="Delete task">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>
