<?php
$isEdit = isset($mode) && $mode === 'edit' && !empty($task);
$action = $isEdit
    ? "/lead-management/public/app/tasks/" . (int)$task['id'] . "/update"
    : "/lead-management/public/app/tasks/store";

$title       = $task['title']       ?? ($_SESSION['form_data']['title']       ?? '');
$description = $task['description'] ?? ($_SESSION['form_data']['description'] ?? '');
$dueDate     = $task['due_date']    ?? ($_SESSION['form_data']['due_date']    ?? '');
$priority    = $task['priority']    ?? ($_SESSION['form_data']['priority']    ?? 'medium');
$status      = $task['status']      ?? ($_SESSION['form_data']['status']      ?? 'pending');

unset($_SESSION['form_data']);
?>
<style>
    .tasks-form-root {
        max-width: 720px;
        margin: 0 auto;
        padding: 24px 24px 40px;
        font-family: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text", sans-serif;
        color: #0f172a;
    }

    .tasks-form-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        gap: 16px;
        margin-bottom: 20px;
    }

    .tasks-form-title {
        font-size: 1.6rem;
        font-weight: 700;
        margin: 0 0 4px;
    }

    .tasks-form-subtitle {
        margin: 0;
        font-size: 0.95rem;
        color: #64748b;
    }

    .tasks-form-card {
        background: rgba(255, 255, 255, 0.96);
        border-radius: 18px;
        border: 1px solid rgba(148, 163, 184, 0.25);
        box-shadow:
            0 18px 40px rgba(15, 23, 42, 0.08),
            0 0 0 1px rgba(255, 255, 255, 0.6) inset;
    }

    .tasks-form-card-header {
        padding: 16px 18px 0;
    }

    .tasks-form-card-title {
        margin: 0 0 6px;
        font-size: 1.05rem;
        font-weight: 600;
    }

    .tasks-form-card-subtitle {
        margin: 0 0 10px;
        font-size: 0.85rem;
        color: #64748b;
    }

    .tasks-form-card-body {
        padding: 12px 18px 18px;
    }

    .tasks-form-grid {
        display: grid;
        grid-template-columns: repeat(2, minmax(0, 1fr));
        gap: 14px 14px;
    }

    .tasks-form-group.full {
        grid-column: 1 / -1;
    }

    .tasks-form-label {
        display: block;
        font-size: 0.8rem;
        font-weight: 500;
        margin-bottom: 4px;
        color: #64748b;
    }

    .tasks-form-input,
    .tasks-form-select,
    .tasks-form-textarea {
        width: 100%;
        border-radius: 10px;
        border: 1px solid #cbd5f5;
        padding: 8px 10px;
        font-size: 0.9rem;
        outline: none;
        background: #f8fafc;
        transition: border-color 0.12s ease, box-shadow 0.12s ease, background 0.12s ease;
    }

    .tasks-form-textarea {
        resize: vertical;
        min-height: 120px;
        border-radius: 14px;
    }

    .tasks-form-input:focus,
    .tasks-form-select:focus,
    .tasks-form-textarea:focus {
        border-color: #0ea5e9;
        box-shadow: 0 0 0 1px rgba(14, 165, 233, 0.25);
        background: #ffffff;
    }

    .tasks-form-required {
        color: #e11d48;
    }

    .tasks-form-actions {
        grid-column: 1 / -1;
        display: flex;
        justify-content: flex-end;
        gap: 10px;
        margin-top: 6px;
    }

    .tasks-btn {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        border-radius: 999px;
        border: none;
        padding: 8px 16px;
        font-size: 0.9rem;
        font-weight: 500;
        text-decoration: none;
        cursor: pointer;
        background: #0ea5e9;
        color: #e0f2fe;
        box-shadow: 0 10px 20px rgba(14, 165, 233, 0.25);
        transition: transform 0.1s ease, box-shadow 0.1s ease, background 0.1s ease;
        white-space: nowrap;
    }

    .tasks-btn i {
        font-size: 0.9rem;
    }

    .tasks-btn:hover {
        background: #0284c7;
        transform: translateY(-1px);
        box-shadow: 0 14px 30px rgba(14, 165, 233, 0.35);
    }

    .tasks-btn-ghost {
        background: transparent;
        color: #64748b;
        box-shadow: none;
    }

    .tasks-btn-ghost:hover {
        background: #e5e7eb;
        color: #0f172a;
        box-shadow: none;
    }
</style>

<div class="tasks-form-root">
    <div class="tasks-form-header">
        <div>
            <h1 class="tasks-form-title">
                <?= $isEdit ? 'Edit Task' : 'New Task' ?>
            </h1>
            <p class="tasks-form-subtitle">
                <?= $isEdit
                    ? 'Update the details and status of this task.'
                    : 'Create a task to track follow-ups and internal work.'
                ?>
            </p>
        </div>
        <div>
            <a href="/lead-management/public/app/tasks" class="tasks-btn tasks-btn-ghost">
                <i class="fas fa-arrow-left"></i>
                <span>Back to Tasks</span>
            </a>
        </div>
    </div>

    <div class="tasks-form-card">
        <div class="tasks-form-card-header">
            <h2 class="tasks-form-card-title">Task details</h2>
            <p class="tasks-form-card-subtitle">
                Give this task a clear title, priority, and optional due date.
            </p>
        </div>
        <div class="tasks-form-card-body">
            <form method="POST" action="<?= htmlspecialchars($action) ?>">
                <div class="tasks-form-grid">
                    <div class="tasks-form-group full">
                        <label for="title" class="tasks-form-label">
                            Title <span class="tasks-form-required">*</span>
                        </label>
                        <input
                            type="text"
                            id="title"
                            name="title"
                            class="tasks-form-input"
                            value="<?= htmlspecialchars($title) ?>"
                            required
                            placeholder="Follow up with ACME about proposal"
                        >
                    </div>

                    <div class="tasks-form-group full">
                        <label for="description" class="tasks-form-label">Description</label>
                        <textarea
                            id="description"
                            name="description"
                            class="tasks-form-textarea"
                            placeholder="Add context, links, or details for this task..."
                        ><?= htmlspecialchars($description) ?></textarea>
                    </div>

                    <div class="tasks-form-group">
                        <label for="priority" class="tasks-form-label">Priority</label>
                        <select id="priority" name="priority" class="tasks-form-select">
                            <option value="low" <?= $priority === 'low' ? 'selected' : '' ?>>Low</option>
                            <option value="medium" <?= $priority === 'medium' ? 'selected' : '' ?>>Medium</option>
                            <option value="high" <?= $priority === 'high' ? 'selected' : '' ?>>High</option>
                            <option value="urgent" <?= $priority === 'urgent' ? 'selected' : '' ?>>Urgent</option>
                        </select>
                    </div>

                    <div class="tasks-form-group">
                        <label for="due_date" class="tasks-form-label">Due date</label>
                        <input
                            type="date"
                            id="due_date"
                            name="due_date"
                            class="tasks-form-input"
                            value="<?= $dueDate ? htmlspecialchars(substr($dueDate, 0, 10)) : '' ?>"
                        >
                    </div>

                    <?php if ($isEdit): ?>
                        <div class="tasks-form-group">
                            <label for="status" class="tasks-form-label">Status</label>
                            <select id="status" name="status" class="tasks-form-select">
                                <option value="pending"     <?= $status === 'pending' ? 'selected' : '' ?>>Pending</option>
                                <option value="in_progress" <?= $status === 'in_progress' ? 'selected' : '' ?>>In progress</option>
                                <option value="completed"   <?= $status === 'completed' ? 'selected' : '' ?>>Completed</option>
                                <option value="blocked"     <?= $status === 'blocked' ? 'selected' : '' ?>>Blocked</option>
                            </select>
                        </div>
                    <?php endif; ?>

                    <div class="tasks-form-actions">
                        <button type="submit" class="tasks-btn">
                            <i class="fas fa-save"></i>
                            <span><?= $isEdit ? 'Save changes' : 'Create task' ?></span>
                        </button>
                        <a href="/lead-management/public/app/tasks" class="tasks-btn tasks-btn-ghost">
                            Cancel
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
