<div class="dashboard-container">
    <style>
        .form-card {
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.98), rgba(240, 249, 255, 0.98));
            border-radius: 16px;
            padding: 1.75rem 2rem;
            box-shadow: 0 8px 24px rgba(15, 23, 42, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.9);
        }

        .form-grid {
            display: grid;
            grid-template-columns: repeat(2, minmax(0, 1fr));
            gap: 1rem 1.5rem;
        }

        .form-field {
            display: flex;
            flex-direction: column;
            gap: 0.25rem;
        }

        .form-field label {
            font-size: 0.9rem;
            font-weight: 600;
            color: var(--sky-800);
        }

        .form-field input,
        .form-field select,
        .form-field textarea {
            padding: 0.55rem 0.75rem;
            border-radius: 10px;
            border: 1px solid var(--sky-200);
            font-size: 0.9rem;
            background: #fff;
        }

        .form-actions {
            margin-top: 1.5rem;
            display: flex;
            gap: 0.75rem;
            justify-content: flex-end;
        }

        .btn-primary {
            padding: 0.6rem 1.4rem;
            background: var(--primary);
            color: #fff;
            border-radius: 999px;
            border: none;
            font-size: 0.9rem;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
            box-shadow: 0 8px 18px rgba(37, 99, 235, 0.3);
        }

        .btn-secondary {
            padding: 0.6rem 1.4rem;
            background: rgba(15, 23, 42, 0.04);
            color: var(--sky-800);
            border-radius: 999px;
            border: none;
            font-size: 0.9rem;
            cursor: pointer;
        }

        @media (max-width: 768px) {
            .form-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <header class="page-header">
        <div>
            <div class="page-header-title">New Lead</div>
            <div class="page-header-subtitle">
                Add a lead manually to your pipeline.
            </div>
        </div>
    </header>

    <section class="form-card">
        <form action="/lead-management/public/app/leads/store" method="POST">
            <div class="form-grid">
                <div class="form-field">
                    <label for="first_name">First Name</label>
                    <input id="first_name" name="first_name" type="text" required>
                </div>
                <div class="form-field">
                    <label for="last_name">Last Name</label>
                    <input id="last_name" name="last_name" type="text">
                </div>

                <div class="form-field">
                    <label for="email">Email</label>
                    <input id="email" name="email" type="email">
                </div>
                <div class="form-field">
                    <label for="phone">Phone</label>
                    <input id="phone" name="phone" type="text">
                </div>

                <div class="form-field">
                    <label for="status">Status</label>
                    <select id="status" name="status">
                        <option value="new">New</option>
                        <option value="open">Open</option>
                        <option value="won">Won</option>
                        <option value="lost">Lost</option>
                    </select>
                </div>
                <div class="form-field">
                    <label for="ai_score">AI Score (optional)</label>
                    <input id="ai_score" name="ai_score" type="number" min="0" max="100" step="1">
                </div>

                <div class="form-field" style="grid-column: 1 / -1;">
                    <label for="notes">Notes</label>
                    <textarea id="notes" name="notes" rows="3"></textarea>
                </div>
            </div>

            <div class="form-actions">
                <button type="button" class="btn-secondary"
                    onclick="window.location.href='/lead-management/public/app/leads'">
                    Cancel
                </button>
                <button type="submit" class="btn-primary">
                    Save Lead
                </button>
            </div>
        </form>
    </section>
</div>