<?php
// Expected from controller:
// $form        = ['id' => ..., 'name' => ...] (or 'title')
// $submissions = array of assoc arrays
$formName = $form['name'] ?? ($form['title'] ?? ('Form #'.($form['id'] ?? '')));
?>
<div class="dashboard-container">
    <style>
        .page-header {
            background: rgba(255,255,255,0.9);
            backdrop-filter: blur(18px);
            border-radius: 16px;
            padding: 1.5rem 2rem;
            margin-bottom: 1.5rem;
            box-shadow: 0 8px 20px rgba(15, 23, 42, 0.08);
            border: 1px solid rgba(255,255,255,0.9);
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1rem;
        }
        .page-header-title {
            font-size: 1.6rem;
            font-weight: 700;
            color: var(--sky-800);
        }
        .page-header-subtitle {
            color: var(--sky-700);
            font-size: 0.95rem;
        }
        .page-header-actions .btn-primary {
            padding: 0.6rem 1.3rem;
            background: var(--primary);
            color: #fff;
            border: none;
            border-radius: 999px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }
        .page-header-actions .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
            box-shadow: 0 8px 18px rgba(37,99,235,0.35);
        }

        .submissions-layout {
            display: grid;
            grid-template-columns: 1.1fr 2.2fr;
            gap: 1.5rem;
        }
        @media (max-width: 1024px) {
            .submissions-layout {
                grid-template-columns: 1fr;
            }
        }

        .summary-card,
        .submissions-card {
            background: linear-gradient(135deg, rgba(255,255,255,0.98), rgba(240,249,255,0.98));
            border-radius: 16px;
            padding: 1.5rem 1.75rem;
            box-shadow: 0 8px 24px rgba(15,23,42,0.08);
            border: 1px solid rgba(255,255,255,0.9);
            position: relative;
            overflow: hidden;
        }
        .summary-card::before {
            content: "";
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 4px;
            background: linear-gradient(90deg, var(--primary-light), var(--primary));
            background-size: 200% 100%;
            animation: gradientShift 4s ease infinite;
        }
        .submissions-card::before {
            content: "";
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 4px;
            background: linear-gradient(90deg, var(--sky-400), var(--sky-600));
            background-size: 200% 100%;
            animation: gradientShift 4s ease infinite;
        }

        @keyframes gradientShift {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        .summary-title {
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--sky-800);
            margin-bottom: 1rem;
        }
        .summary-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }
        .summary-item {
            background: rgba(255,255,255,0.9);
            border-radius: 12px;
            padding: 0.8rem 0.9rem;
            border: 1px solid var(--sky-100);
        }
        .summary-label {
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.08em;
            color: var(--sky-600);
            margin-bottom: 0.25rem;
        }
        .summary-value {
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--sky-900);
        }

        .submissions-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }
        .submissions-header h2 {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--sky-800);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        .submissions-search {
            display: flex;
            gap: 0.5rem;
            align-items: center;
        }
        .submissions-search input {
            padding: 0.4rem 0.75rem;
            border-radius: 999px;
            border: 1px solid var(--sky-200);
            background: #fff;
            font-size: 0.85rem;
            min-width: 200px;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.85rem;
        }
        .data-table thead {
            background: var(--sky-50);
        }
        .data-table th,
        .data-table td {
            padding: 0.55rem 0.7rem;
            text-align: left;
            vertical-align: top;
        }
        .data-table th {
            font-size: 0.75rem;
            letter-spacing: 0.06em;
            text-transform: uppercase;
            color: var(--sky-700);
            border-bottom: 1px solid var(--sky-200);
        }
        .data-table tbody tr {
            background: rgba(255,255,255,0.96);
            border-bottom: 1px solid var(--sky-100);
            transition: var(--transition);
        }
        .data-table tbody tr:hover {
            background: var(--sky-50);
        }

        .badge-status {
            display: inline-flex;
            align-items: center;
            padding: 0.1rem 0.45rem;
            border-radius: 999px;
            font-size: 0.7rem;
            font-weight: 600;
        }
        .badge-status-new {
            background: rgba(59,130,246,0.1);
            color: #1d4ed8;
        }
        .badge-status-reviewed {
            background: rgba(16,185,129,0.1);
            color: #059669;
        }

        .payload-preview {
            font-size: 0.75rem;
            color: var(--sky-700);
            max-width: 260px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        details {
            font-size: 0.8rem;
        }
        details summary {
            cursor: pointer;
            color: var(--primary);
        }
        .empty-state {
            padding: 1.5rem;
            text-align: center;
            color: var(--sky-700);
        }

        @media (max-width: 900px) {
            .data-table { display: block; overflow-x: auto; }
        }
    </style>

    <header class="page-header">
        <div>
            <div class="page-header-title">
                Submissions – <?= htmlspecialchars($formName) ?>
            </div>
            <div class="page-header-subtitle">
                All submissions for this form, using your live dev data.
            </div>
        </div>
        <div class="page-header-actions">
            <button type="button" class="btn-primary"
                    onclick="window.location.href='/lead-management/public/app/forms'">
                ← Back to Forms
            </button>
        </div>
    </header>

    <div class="submissions-layout">
        <!-- Left: Summary -->
        <aside class="summary-card">
            <div class="summary-title">Form summary</div>
            <?php
                $total = is_array($submissions) ? count($submissions) : 0;
                $lastTime = null;
                if ($total > 0) {
                    foreach ($submissions as $sub) {
                        if (!empty($sub['created_at'])) {
                            $ts = strtotime($sub['created_at']);
                            if ($ts && ($lastTime === null || $ts > $lastTime)) {
                                $lastTime = $ts;
                            }
                        }
                    }
                }
            ?>
            <div class="summary-grid">
                <div class="summary-item">
                    <div class="summary-label">Total submissions</div>
                    <div class="summary-value"><?= (int)$total ?></div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">Last submission</div>
                    <div class="summary-value">
                        <?= $lastTime ? date('Y-m-d H:i', $lastTime) : '—' ?>
                    </div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">Form ID</div>
                    <div class="summary-value">
                        <?= htmlspecialchars((string)($form['id'] ?? '—')) ?>
                    </div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">Status</div>
                    <div class="summary-value">
                        <?= htmlspecialchars(ucfirst($form['status'] ?? 'unknown')) ?>
                    </div>
                </div>
            </div>
        </aside>

        <!-- Right: Table -->
        <section class="submissions-card">
            <div class="submissions-header">
                <h2><i class="fas fa-inbox"></i> Submissions</h2>
                <?php if (!empty($submissions)): ?>
                    <div class="submissions-search">
                        <input type="text" placeholder="Filter (client-side)"
                               oninput="filterSubmissions(this.value)">
                    </div>
                <?php endif; ?>
            </div>

            <?php if (empty($submissions)): ?>
                <div class="empty-state">
                    No submissions yet. Share the form embed or public URL to start collecting data.
                </div>
            <?php else: ?>
                <table class="data-table" id="submissions-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Submitted</th>
                            <th>Status</th>
                            <th>Quick preview</th>
                            <th>Full payload</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($submissions as $submission): ?>
                            <?php
                                $sid = $submission['id'] ?? $submission['submission_id'] ?? null;
                                $created = $submission['created_at'] ?? $submission['submitted_at'] ?? '';
                                $status = strtolower($submission['status'] ?? 'new');

                                // Generate a compact JSON preview from the row
                                $previewArr = $submission;
                                // Don't blow up the preview with huge blobs
                                foreach (['payload', 'data', 'json', 'form_data'] as $bigKey) {
                                    if (isset($previewArr[$bigKey]) && strlen((string)$previewArr[$bigKey]) > 150) {
                                        $previewArr[$bigKey] = substr((string)$previewArr[$bigKey], 0, 150) . '…';
                                    }
                                }
                                $previewJson = json_encode($previewArr, JSON_UNESCAPED_UNICODE);

                                $statusClass = 'badge-status';
                                if ($status === 'reviewed' || $status === 'processed') {
                                    $statusClass .= ' badge-status-reviewed';
                                } else {
                                    $statusClass .= ' badge-status-new';
                                }

                                // Try to decode any JSON payload for pretty printing in <details>
                                $payloadData = null;
                                foreach (['payload', 'data', 'json', 'form_data'] as $payloadKey) {
                                    if (!empty($submission[$payloadKey])) {
                                        $decoded = json_decode($submission[$payloadKey], true);
                                        if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                                            $payloadData = $decoded;
                                            break;
                                        }
                                    }
                                }
                            ?>
                            <tr>
                                <td><?= htmlspecialchars((string)$sid) ?></td>
                                <td><?= htmlspecialchars($created ?: '—') ?></td>
                                <td>
                                    <span class="<?= $statusClass ?>">
                                        <?= htmlspecialchars(ucfirst($status)) ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="payload-preview">
                                        <?= htmlspecialchars($previewJson ?? '') ?>
                                    </div>
                                </td>
                                <td>
                                    <details>
                                        <summary>View</summary>
                                        <pre><?php
                                            if ($payloadData !== null) {
                                                echo htmlspecialchars(json_encode($payloadData, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
                                            } else {
                                                echo htmlspecialchars(json_encode($submission, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
                                            }
                                        ?></pre>
                                    </details>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </section>
    </div>
</div>

<script>
    function filterSubmissions(q) {
        q = (q || '').toLowerCase();
        const rows = document.querySelectorAll('#submissions-table tbody tr');
        rows.forEach(row => {
            const text = row.innerText.toLowerCase();
            row.style.display = text.includes(q) ? '' : 'none';
        });
    }
</script>
