<div class="dashboard-container" 
     x-data="formBuilder()" 
     x-init="init(<?= htmlspecialchars(json_encode($defaultStructure)) ?>)">

    <!-- Page Header -->
    <header class="page-header">
        <div class="page-header-main">
            <h1 class="page-title">
                <?= $form ? 'Edit Form' : 'Create New Form' ?>
            </h1>
            <p class="page-subtitle">
                Drag and drop fields to build your lead capture form.
            </p>
        </div>
        <div class="page-header-actions">
            <button type="button" 
                @click="previewForm()"
                class="btn-secondary">
                <i class="fas fa-eye"></i>
                <span>Preview</span>
            </button>
            <button type="button" 
                @click="saveForm()"
                class="btn-primary">
                <i class="fas fa-save"></i>
                <span>Save Form</span>
            </button>
        </div>
    </header>

    <!-- Builder Grid -->
    <div class="builder-grid">
        <!-- Left: Field Palette + Form Settings -->
        <section class="builder-column">
            <div class="content-card">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-cubes"></i>
                        Form Fields
                    </h2>
                    <p class="section-subtitle">Drag fields to the canvas</p>
                </div>
                <div class="field-palette">
                    <?php foreach ($fieldTypes as $type => $config): ?>
                        <div class="field-palette-item"
                             draggable="true"
                             @dragstart="dragStart($event, '<?= $type ?>')">
                            <div class="field-palette-icon">
                                <?= strtoupper(substr($type, 0, 1)) ?>
                            </div>
                            <div class="field-palette-text">
                                <div class="field-palette-title">
                                    <?= htmlspecialchars($config['name']) ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="content-card">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-sliders-h"></i>
                        Form Settings
                    </h2>
                </div>
                <div class="form-settings-grid">
                    <div class="form-field">
                        <label class="form-label">Form Name</label>
                        <input type="text" class="form-input"
                               id="form-name"
                               x-model="formName">
                    </div>
                    <div class="form-field">
                        <label class="form-label">Description</label>
                        <textarea class="form-textarea"
                                  id="form-description"
                                  rows="3"
                                  x-model="formDescription"></textarea>
                    </div>
                    <div class="form-field">
                        <label class="form-label">Success Message</label>
                        <input type="text" class="form-input"
                               id="success-message"
                               x-model="settings.success_message"
                               placeholder="Thank you for your submission!">
                    </div>
                    <div class="form-field">
                        <label class="form-label">Submit Button Text</label>
                        <input type="text" class="form-input"
                               id="submit-text"
                               x-model="settings.submit_text"
                               placeholder="Submit">
                    </div>

                    <div class="settings-toggle">
                        <label class="toggle-label">
                            <input id="auto-create-lead" type="checkbox"
                                   x-model="settings.auto_create_lead">
                            <span>Automatically create leads from submissions</span>
                        </label>
                    </div>

                    <div class="settings-toggle">
                        <label class="toggle-label">
                            <input id="auto-ai-scoring" type="checkbox"
                                   x-model="settings.auto_ai_scoring">
                            <span>Auto-score leads with AI</span>
                        </label>
                    </div>
                </div>
            </div>
        </section>

        <!-- Center: Canvas -->
        <section class="builder-column builder-column-main">
            <div class="content-card">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-object-group"></i>
                        Form Canvas
                    </h2>
                    <p class="section-subtitle">
                        Drag fields here and configure them
                    </p>
                </div>

                <div class="form-canvas"
                     @drop="drop($event)"
                     @dragover="allowDrop($event)">

                    <!-- Empty state -->
                    <div x-show="fields.length === 0" class="form-canvas-empty">
                        <div class="empty-icon">
                            <i class="fas fa-clipboard-list"></i>
                        </div>
                        <h3>No fields yet</h3>
                        <p>Drag fields from the left panel to get started.</p>
                    </div>

                    <!-- Fields list -->
                    <div x-show="fields.length > 0" class="form-fields-list">
                        <template x-for="(field, index) in fields" :key="field.id">
                            <div class="field-item"
                                 :data-field-id="field.id"
                                 @click="selectField(index)">
                                <div class="field-item-header">
                                    <div class="field-item-main">
                                        <div class="field-item-title">
                                            <span x-text="field.label || 'Untitled Field'"></span>
                                            <span x-show="field.required" class="field-required">*</span>
                                        </div>
                                        <div class="field-item-meta">
                                            <span class="badge-pill" x-text="field.type"></span>
                                        </div>
                                    </div>
                                    <div class="field-item-actions">
                                        <button type="button"
                                                @click.stop="moveField(index, -1)"
                                                :disabled="index === 0"
                                                class="icon-button">
                                            <i class="fas fa-arrow-up"></i>
                                        </button>
                                        <button type="button"
                                                @click.stop="moveField(index, 1)"
                                                :disabled="index === fields.length - 1"
                                                class="icon-button">
                                            <i class="fas fa-arrow-down"></i>
                                        </button>
                                        <button type="button"
                                                @click.stop="removeField(index)"
                                                class="icon-button icon-button-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="field-preview">
                                    <!-- text-like -->
                                    <template x-if="['text','email','phone','number'].includes(field.type)">
                                        <input :type="field.type"
                                               :placeholder="field.placeholder || ''"
                                               class="form-input"
                                               disabled>
                                    </template>

                                    <!-- textarea -->
                                    <template x-if="field.type === 'textarea'">
                                        <textarea :placeholder="field.placeholder || ''"
                                                  class="form-textarea"
                                                  rows="3"
                                                  disabled></textarea>
                                    </template>

                                    <!-- select -->
                                    <template x-if="field.type === 'select'">
                                        <select class="form-input" disabled>
                                            <option>Select an option</option>
                                            <template x-for="option in field.options || []">
                                                <option :value="option.value"
                                                        x-text="option.label"></option>
                                            </template>
                                        </select>
                                    </template>

                                    <!-- checkbox / radio -->
                                    <template x-if="['checkbox','radio'].includes(field.type)">
                                        <div class="options-list">
                                            <template x-for="option in field.options || []">
                                                <label class="option-item">
                                                    <input :type="field.type" disabled>
                                                    <span x-text="option.label"></span>
                                                </label>
                                            </template>
                                        </div>
                                    </template>

                                    <!-- date -->
                                    <template x-if="field.type === 'date'">
                                        <input type="date" class="form-input" disabled>
                                    </template>

                                    <!-- file -->
                                    <template x-if="field.type === 'file'">
                                        <input type="file" class="form-input" disabled>
                                    </template>
                                </div>

                                <p x-show="field.description"
                                   class="field-description"
                                   x-text="field.description"></p>
                            </div>
                        </template>
                    </div>
                </div>
            </div>
        </section>

        <!-- Right: Field Properties -->
        <section class="builder-column builder-column-side" x-show="selectedField !== null">
            <div class="content-card sticky-card">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-wrench"></i>
                        Field Properties
                    </h2>
                    <p class="section-subtitle" x-text="getFieldTypeName(selectedField.type)"></p>
                </div>

                <div class="field-props-grid">
                    <div class="form-field">
                        <label class="form-label">Field Label</label>
                        <input type="text" class="form-input"
                               x-model="selectedField.label"
                               @input="updateFieldProperty('label', $event.target.value)">
                    </div>

                    <div class="form-field">
                        <label class="form-label">Field ID</label>
                        <input type="text" class="form-input"
                               x-model="selectedField.id"
                               placeholder="field_name">
                        <p class="help-text">Unique identifier for this field</p>
                    </div>

                    <div class="form-field">
                        <label class="form-label">Placeholder Text</label>
                        <input type="text" class="form-input"
                               x-model="selectedField.placeholder"
                               @input="updateFieldProperty('placeholder', $event.target.value)">
                    </div>

                    <div class="form-field">
                        <label class="form-label">Description</label>
                        <textarea class="form-textarea"
                                  rows="2"
                                  x-model="selectedField.description"
                                  @input="updateFieldProperty('description', $event.target.value)"></textarea>
                    </div>

                    <div class="settings-toggle">
                        <label class="toggle-label">
                            <input type="checkbox"
                                   x-model="selectedField.required"
                                   @change="updateFieldProperty('required', $event.target.checked)">
                            <span>Required field</span>
                        </label>
                    </div>

                    <!-- Options (select, checkbox, radio) -->
                    <template x-if="['select','radio','checkbox'].includes(selectedField.type)">
                        <div class="form-field">
                            <label class="form-label">Options</label>
                            <div class="options-editor">
                                <template x-for="(option, optionIndex) in selectedField.options" :key="optionIndex">
                                    <div class="option-row">
                                        <input type="text" class="form-input"
                                               x-model="option.label"
                                               placeholder="Option label">
                                        <input type="text" class="form-input"
                                               x-model="option.value"
                                               placeholder="Value">
                                        <button type="button"
                                                class="icon-button icon-button-danger"
                                                @click="removeOption(optionIndex)">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </template>
                                <button type="button"
                                        class="btn-ghost"
                                        @click="addOption()">
                                    <i class="fas fa-plus"></i>
                                    <span>Add option</span>
                                </button>
                            </div>
                        </div>
                    </template>

                    <!-- File settings -->
                    <template x-if="selectedField.type === 'file'">
                        <div class="form-field">
                            <label class="form-label">Accepted File Types</label>
                            <input type="text" class="form-input"
                                   x-model="selectedField.accept"
                                   @input="updateFieldProperty('accept', $event.target.value)"
                                   placeholder=".pdf,.doc,.docx,.jpg,.png">
                            <p class="help-text">Comma-separated file extensions</p>
                        </div>
                    </template>
                </div>
            </div>
        </section>
    </div>

    <!-- Preview Modal -->
    <div x-show="showPreview"
         class="modal-backdrop">
        <div class="modal-dialog">
            <div class="modal-card">
                <div class="modal-header">
                    <h3>Form Preview</h3>
                </div>
                <div class="modal-body">
                    <div class="preview-wrapper">
                        <form class="preview-form space-y-4">
                            <template x-for="field in fields" :key="field.id">
                                <div class="preview-field">
                                    <label class="form-label">
                                        <span x-text="field.label"></span>
                                        <span x-show="field.required" class="field-required">*</span>
                                    </label>

                                    <!-- reuse same input templates -->
                                    <template x-if="['text','email','phone','number'].includes(field.type)">
                                        <input :type="field.type"
                                               :placeholder="field.placeholder || ''"
                                               class="form-input">
                                    </template>

                                    <template x-if="field.type === 'textarea'">
                                        <textarea :placeholder="field.placeholder || ''"
                                                  class="form-textarea"
                                                  rows="3"></textarea>
                                    </template>

                                    <template x-if="field.type === 'select'">
                                        <select class="form-input">
                                            <option value="">Select an option</option>
                                            <template x-for="option in field.options || []">
                                                <option :value="option.value"
                                                        x-text="option.label"></option>
                                            </template>
                                        </select>
                                    </template>

                                    <template x-if="field.type === 'checkbox'">
                                        <div class="options-list">
                                            <template x-for="option in field.options || []">
                                                <label class="option-item">
                                                    <input type="checkbox"
                                                           :value="option.value">
                                                    <span x-text="option.label"></span>
                                                </label>
                                            </template>
                                        </div>
                                    </template>

                                    <template x-if="field.type === 'radio'">
                                        <div class="options-list">
                                            <template x-for="option in field.options || []">
                                                <label class="option-item">
                                                    <input type="radio"
                                                           :name="field.id"
                                                           :value="option.value">
                                                    <span x-text="option.label"></span>
                                                </label>
                                            </template>
                                        </div>
                                    </template>

                                    <template x-if="field.type === 'date'">
                                        <input type="date" class="form-input">
                                    </template>

                                    <template x-if="field.type === 'file'">
                                        <input type="file"
                                               :accept="field.accept || ''"
                                               class="form-input">
                                    </template>

                                    <p x-show="field.description"
                                       class="field-description"
                                       x-text="field.description"></p>
                                </div>
                            </template>

                            <button type="submit" class="btn-primary w-100">
                                <span x-text="settings.submit_text || 'Submit'"></span>
                            </button>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button"
                            class="btn-secondary w-100"
                            @click="showPreview = false">
                        Close Preview
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Alpine formBuilder() logic (unchanged, just moved) -->
<script>
function formBuilder() {
    return {
        formName: '<?= $form ? htmlspecialchars($form['name']) : "New Form" ?>',
        formDescription: '<?= $form ? htmlspecialchars($form['description']) : "" ?>',
        fields: [],
        selectedField: null,
        selectedFieldIndex: null,
        showPreview: false,
        settings: {
            success_message: 'Thank you for your submission!',
            submit_text: 'Submit',
            auto_create_lead: true,
            auto_ai_scoring: true
        },
        fieldTypes: <?= json_encode($fieldTypes) ?>,

        init(defaultStructure) {
            if (defaultStructure && defaultStructure.fields) {
                this.fields = defaultStructure.fields;
                this.settings = { ...this.settings, ...defaultStructure.settings };
            }

            <?php if ($form): ?>
                this.formName = '<?= htmlspecialchars($form['name']) ?>';
                this.formDescription = '<?= htmlspecialchars($form['description']) ?>';
            <?php endif; ?>
        },

        dragStart(event, fieldType) {
            event.dataTransfer.setData('application/json', JSON.stringify({
                type: fieldType,
                id: 'field_' + Date.now() + '_' + Math.random().toString(36).substr(2, 9)
            }));
        },

        allowDrop(event) {
            event.preventDefault();
        },

        drop(event) {
            event.preventDefault();
            const data = JSON.parse(event.dataTransfer.getData('application/json'));

            const newField = {
                id: data.id,
                type: data.type,
                label: this.getFieldTypeName(data.type),
                required: false,
                placeholder: '',
                description: ''
            };

            if (['select', 'radio', 'checkbox'].includes(data.type)) {
                newField.options = [
                    { label: 'Option 1', value: 'option1' },
                    { label: 'Option 2', value: 'option2' }
                ];
            }

            this.fields.push(newField);
            this.selectField(this.fields.length - 1);
        },

        selectField(index) {
            this.selectedFieldIndex = index;
            this.selectedField = this.fields[index];
        },

        updateFieldProperty(property, value) {
            if (this.selectedFieldIndex !== null) {
                this.fields[this.selectedFieldIndex][property] = value;
            }
        },

        removeField(index) {
            this.fields.splice(index, 1);
            if (this.selectedFieldIndex === index) {
                this.selectedField = null;
                this.selectedFieldIndex = null;
            } else if (this.selectedFieldIndex > index) {
                this.selectedFieldIndex--;
            }
        },

        moveField(index, direction) {
            const newIndex = index + direction;
            if (newIndex >= 0 && newIndex < this.fields.length) {
                const field = this.fields.splice(index, 1)[0];
                this.fields.splice(newIndex, 0, field);
                this.selectedFieldIndex = newIndex;
            }
        },

        addOption() {
            if (this.selectedField && this.selectedField.options) {
                this.selectedField.options.push({
                    label: 'New Option',
                    value: 'new_option_' + Date.now()
                });
            }
        },

        removeOption(index) {
            if (this.selectedField && this.selectedField.options) {
                this.selectedField.options.splice(index, 1);
            }
        },

        getFieldTypeName(type) {
            return this.fieldTypes[type]?.name || type;
        },

        previewForm() {
            this.showPreview = true;
        },

        async saveForm() {
            const formStructure = {
                fields: this.fields,
                settings: this.settings,
                version: '1.0'
            };

            const formData = new FormData();
            formData.append('name', this.formName);
            formData.append('description', this.formDescription);
            formData.append('structure', JSON.stringify(formStructure));
            formData.append('settings', JSON.stringify(this.settings));

            try {
                const response = await fetch('<?= $form ? "/lead-management/public/app/forms/{$form['id']}/edit" : "/lead-management/public/app/forms/create" ?>', {
                    method: 'POST',
                    body: formData
                });

                if (response.ok) {
                    window.location.href = '/lead-management/public/app/forms';
                } else {
                    alert('Error saving form');
                }
            } catch (error) {
                alert('Error saving form: ' + error.message);
            }
        }
    }
}
</script>

<style>
/* SkyBlue-ish layout tweaks specifically for builder */

.dashboard-container {
    padding: 2rem;
}

.page-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 1.5rem;
    margin-bottom: 1.5rem;
}

.page-title {
    font-size: 1.8rem;
    font-weight: 800;
    color: var(--sky-800, #0f172a);
}

.page-subtitle {
    color: var(--sky-700, #0369a1);
    font-size: 0.95rem;
}

.page-header-actions {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.btn-primary,
.btn-secondary,
.btn-ghost {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    border-radius: var(--radius, 10px);
    padding: 0.6rem 1.1rem;
    font-size: 0.9rem;
    font-weight: 600;
    border: none;
    cursor: pointer;
    transition: var(--transition, all .2s ease);
    text-decoration: none;
}

.btn-primary {
    background: var(--primary, #3b82f6);
    color: #fff;
}

.btn-primary:hover {
    background: var(--primary-dark, #2563eb);
}

.btn-secondary {
    background: #fff;
    color: var(--sky-800, #0f172a);
    border: 1px solid var(--sky-200, #e0f2fe);
}

.btn-secondary:hover {
    background: var(--sky-50, #f0f9ff);
}

.btn-ghost {
    background: transparent;
    color: var(--primary, #3b82f6);
    border: 1px dashed var(--sky-300, #7dd3fc);
}

.btn-ghost:hover {
    background: var(--sky-50, #f0f9ff);
}

.btn-primary.w-100,
.btn-secondary.w-100 {
    width: 100%;
    justify-content: center;
}

/* Grid */

.builder-grid {
    display: grid;
    grid-template-columns: 1.2fr 2fr 1.2fr;
    gap: 1.5rem;
}

.builder-column {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.builder-column-main {
    min-width: 0;
}

.builder-column-side {
    min-width: 260px;
}

@media (max-width: 1200px) {
    .builder-grid {
        grid-template-columns: 1fr 1.4fr;
    }
    .builder-column-side {
        grid-column: 1 / -1;
    }
}

@media (max-width: 900px) {
    .builder-grid {
        grid-template-columns: 1fr;
    }
    .builder-column-side {
        min-width: 0;
    }
}

/* Cards */

.content-card {
    background: linear-gradient(135deg, rgba(255,255,255,0.98), rgba(240,249,255,0.98));
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 10px 25px -10px rgba(15,23,42,0.12);
    border: 1px solid rgba(255,255,255,0.9);
    position: relative;
    overflow: hidden;
}

.content-card::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    height: 3px;
    width: 100%;
    background: linear-gradient(90deg, var(--primary-light, #60a5fa), var(--primary, #3b82f6));
}

/* Section header */

.section-header h2 {
    font-size: 1.05rem;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: var(--sky-800, #0f172a);
}

.section-header h2 i {
    color: var(--primary, #3b82f6);
}

.section-subtitle {
    margin-top: 0.25rem;
    font-size: 0.85rem;
    color: var(--sky-700, #0369a1);
}

/* Palette */

.field-palette {
    margin-top: 1rem;
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.field-palette-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    background: var(--sky-50, #f0f9ff);
    border-radius: 12px;
    border: 1px solid var(--sky-100, #e0f2fe);
    padding: 0.6rem 0.75rem;
    cursor: grab;
    transition: var(--transition, all .2s ease);
}

.field-palette-item:hover {
    transform: translateY(-1px);
    background: #fff;
    border-color: var(--primary-light, #60a5fa);
    box-shadow: 0 4px 12px rgba(59,130,246,0.1);
}

.field-palette-icon {
    width: 32px;
    height: 32px;
    border-radius: 10px;
    background: #fff;
    border: 1px solid var(--sky-200, #bae6fd);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.85rem;
    font-weight: 600;
    color: var(--primary, #3b82f6);
}

.field-palette-title {
    font-size: 0.9rem;
    font-weight: 600;
    color: var(--sky-800, #0f172a);
}

/* Settings */

.form-settings-grid {
    margin-top: 1rem;
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.form-field {
    display: flex;
    flex-direction: column;
    gap: 0.35rem;
}

.form-label {
    font-size: 0.85rem;
    font-weight: 600;
    color: var(--sky-800, #0f172a);
}

.form-input,
.form-textarea,
select.form-input {
    border-radius: 10px;
    border: 1px solid var(--sky-200, #e0f2fe);
    padding: 0.55rem 0.75rem;
    font-size: 0.9rem;
    outline: none;
    background: #fff;
    transition: var(--transition, all .2s ease);
    width: 100%;
}

.form-input:focus,
.form-textarea:focus {
    border-color: var(--primary, #3b82f6);
    box-shadow: 0 0 0 1px rgba(59,130,246,0.15);
}

.form-textarea {
    resize: vertical;
    min-height: 80px;
}

/* Toggles */

.settings-toggle {
    margin-top: 0.25rem;
}

.toggle-label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.85rem;
    color: var(--sky-800, #0f172a);
}

.toggle-label input[type="checkbox"] {
    width: 16px;
    height: 16px;
}

/* Canvas */

.form-canvas {
    margin-top: 1rem;
    min-height: 300px;
    border-radius: 14px;
    border: 2px dashed var(--sky-200, #bae6fd);
    background: rgba(248, 250, 252, 0.85);
    padding: 1rem;
    transition: var(--transition, all .2s ease);
}

.form-canvas.drag-over {
    border-color: var(--primary, #3b82f6);
    background: var(--sky-50, #f0f9ff);
}

.form-canvas-empty {
    text-align: center;
    padding: 2rem 1rem;
    color: var(--sky-700, #0369a1);
}

.form-canvas-empty h3 {
    font-size: 1rem;
    font-weight: 700;
    margin-top: 0.5rem;
    margin-bottom: 0.25rem;
}

.form-canvas-empty p {
    font-size: 0.85rem;
}

.empty-icon {
    width: 44px;
    height: 44px;
    border-radius: 50%;
    border: 1px dashed var(--sky-300, #7dd3fc);
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    color: var(--primary, #3b82f6);
}

.form-fields-list {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

/* Field items */

.field-item {
    background: #fff;
    border-radius: 12px;
    border: 1px solid var(--sky-200, #e0f2fe);
    padding: 0.75rem 0.8rem;
    cursor: pointer;
    transition: var(--transition, all .2s ease);
}

.field-item:hover {
    border-color: var(--primary-light, #60a5fa);
    box-shadow: 0 4px 10px rgba(59,130,246,0.08);
}

.field-item-header {
    display: flex;
    justify-content: space-between;
    gap: 0.75rem;
    align-items: flex-start;
}

.field-item-main {
    flex: 1;
    min-width: 0;
}

.field-item-title {
    display: flex;
    align-items: center;
    gap: 0.35rem;
    font-size: 0.95rem;
    font-weight: 600;
    color: var(--sky-800, #0f172a);
}

.field-required {
    color: var(--danger, #ef4444);
    font-size: 0.8rem;
}

.field-item-meta {
    margin-top: 0.15rem;
}

.badge-pill {
    display: inline-flex;
    align-items: center;
    padding: 0.1rem 0.45rem;
    border-radius: 999px;
    font-size: 0.7rem;
    background: var(--sky-100, #e0f2fe);
    color: var(--sky-800, #0f172a);
    text-transform: uppercase;
}

.field-item-actions {
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.icon-button {
    border: none;
    background: transparent;
    padding: 0.25rem;
    border-radius: 999px;
    cursor: pointer;
    color: var(--sky-600, #0284c7);
    transition: var(--transition, all .2s ease);
}

.icon-button:hover {
    background: var(--sky-100, #e0f2fe);
}

.icon-button-danger {
    color: var(--danger, #ef4444);
}

.icon-button-danger:hover {
    background: rgba(239, 68, 68, 0.08);
}

.field-preview {
    margin-top: 0.5rem;
}

.field-description {
    margin-top: 0.25rem;
    font-size: 0.8rem;
    color: var(--sky-700, #0369a1);
}

/* Options */

.options-list {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
    margin-top: 0.25rem;
}

.option-item {
    display: flex;
    align-items: center;
    gap: 0.4rem;
    font-size: 0.85rem;
    color: var(--sky-800, #0f172a);
}

.option-row {
    display: grid;
    grid-template-columns: 1.4fr 1.4fr auto;
    gap: 0.4rem;
    margin-bottom: 0.4rem;
}

/* Sidebar card */

.sticky-card {
    position: sticky;
    top: 1.25rem;
}

/* Help text */

.help-text {
    font-size: 0.75rem;
    color: var(--sky-700, #0369a1);
}

/* Modal */

.modal-backdrop {
    position: fixed;
    inset: 0;
    background: rgba(15,23,42,0.4);
    display: flex;
    align-items: flex-start;
    justify-content: center;
    padding: 3rem 1rem;
    z-index: 1050;
}

.modal-dialog {
    max-width: 560px;
    width: 100%;
}

.modal-card {
    background: #fff;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 20px 45px rgba(15,23,42,0.45);
}

.modal-header {
    padding: 1rem 1.25rem;
    border-bottom: 1px solid #e5e7eb;
}

.modal-header h3 {
    margin: 0;
    font-size: 1rem;
    font-weight: 700;
    color: var(--sky-800, #0f172a);
}

.modal-body {
    padding: 1.25rem;
    background: var(--sky-50, #f0f9ff);
}

.preview-wrapper {
    background: #fff;
    border-radius: 12px;
    padding: 1rem;
    border: 1px solid var(--sky-100, #e0f2fe);
}

.modal-footer {
    padding: 0.9rem 1.25rem 1.1rem;
    border-top: 1px solid #e5e7eb;
}

/* Responsive header */

@media (max-width: 768px) {
    .page-header {
        flex-direction: column;
        align-items: stretch;
    }
    .page-header-actions {
        justify-content: flex-start;
    }
}
</style>
