<?php
// Resources/views/pages/ai-tools.php
// SkyBlue AI Tools Hub
?>
<div class="dashboard-container">
    <!-- Header -->
    <header class="dashboard-header">
        <div class="header-content">
            <div class="welcome-section">
                <h1>AI Tools & Automation</h1>
                <p>Configure your AI provider and use smart tools to score leads, generate emails, and analyze behavior.</p>
            </div>
        </div>

        <!-- Quick Stats (optional static for now) -->
        <div class="quick-stats">
            <div class="stat-card">
                <div class="stat-number">82%</div>
                <div class="stat-label">AI-Scored Leads</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">147</div>
                <div class="stat-label">Emails Generated</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">68%</div>
                <div class="stat-label">Open / Reply Rate</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">24</div>
                <div class="stat-label">Behavior Insights</div>
            </div>
        </div>
    </header>

    <!-- Main Grid -->
    <div class="dashboard-grid">
        <!-- Left column -->
        <div class="left-column">
            <!-- AI Configuration -->
            <section class="tasks-section">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-robot"></i>
                        AI Provider Configuration
                    </h2>
                </div>

                <p style="margin-bottom: 1rem; color: var(--sky-700);">
                    Connect your AI provider so LeadIntelligence can score leads, generate emails, 
                    and analyze behavior. Your API key is stored securely per user.
                </p>

                <form id="ai-config-form" class="ai-config-form" onsubmit="return false;">
                    <div style="display: grid; grid-template-columns: 1fr; gap: 1rem; max-width: 480px;">
                        <div>
                            <label class="form-label" for="ai_provider" style="display:block;font-size:0.9rem;font-weight:600;color:var(--sky-800);margin-bottom:0.25rem;">
                                AI Provider
                            </label>
                            <select id="ai_provider" name="ai_provider"
                                style="width:100%;padding:0.6rem 0.75rem;border-radius:10px;border:1px solid var(--sky-200);background:white;">
                                <option value="openai">OpenAI (Recommended)</option>
                                <option value="anthropic">Anthropic</option>
                                <option value="azure_openai">Azure OpenAI</option>
                                <option value="custom">Custom / Proxy</option>
                            </select>
                        </div>

                        <div>
                            <label class="form-label" for="api_key" style="display:block;font-size:0.9rem;font-weight:600;color:var(--sky-800);margin-bottom:0.25rem;">
                                API Key
                            </label>
                            <input
                                type="password"
                                id="api_key"
                                name="api_key"
                                placeholder="sk-********************************"
                                style="width:100%;padding:0.6rem 0.75rem;border-radius:10px;border:1px solid var(--sky-200);background:white;"
                            >
                            <p style="font-size:0.75rem;color:var(--sky-700);margin-top:0.35rem;">
                                Only used server-side for lead scoring, email generation, and analytics.
                            </p>
                        </div>

                        <div style="display:flex;gap:0.75rem;align-items:center;margin-top:0.5rem;">
                            <button
                                type="button"
                                id="save-ai-config-btn"
                                style="padding:0.7rem 1.5rem;border:none;border-radius: var(--radius);
                                       background: var(--primary);color:white;font-weight:600;cursor:pointer;
                                       display:inline-flex;align-items:center;gap:0.5rem;">
                                <i class="fas fa-save"></i>
                                Save Configuration
                            </button>

                            <button
                                type="button"
                                id="test-ai-config-btn"
                                style="padding:0.7rem 1.2rem;border:1px solid var(--primary-light);
                                       border-radius: var(--radius);background:white;color:var(--primary);
                                       font-weight:600;cursor:pointer;display:inline-flex;align-items:center;gap:0.5rem;">
                                <i class="fas fa-vial"></i>
                                Test Connection
                            </button>
                        </div>

                        <div id="ai-config-status" style="font-size:0.85rem;margin-top:0.5rem;"></div>
                    </div>
                </form>
            </section>

            <!-- Lead Scoring & Behavior Tools -->
            <section class="reports-section">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-chart-line"></i>
                        Lead AI Tools
                    </h2>
                </div>

                <p style="margin-bottom:1rem;color:var(--sky-700);">
                    Use AI to prioritize your pipeline and understand lead intent.
                </p>

                <div class="quick-actions-grid">
                    <a href="/lead-management/public/app/leads"
                       class="action-card" style="text-decoration:none;">
                        <div class="action-icon">
                            <i class="fas fa-bolt"></i>
                        </div>
                        <div class="action-title">Score New Leads</div>
                        <div class="action-desc">Open leads list and trigger AI scoring on fresh leads.</div>
                    </a>

                    <a href="/lead-management/public/app/leads?filter=high_score"
                       class="action-card" style="text-decoration:none;">
                        <div class="action-icon">
                            <i class="fas fa-fire"></i>
                        </div>
                        <div class="action-title">High Priority Queue</div>
                        <div class="action-desc">Jump straight to hot leads with high AI scores.</div>
                    </a>

                    <a href="/lead-management/public/app/leads?filter=needs_email"
                       class="action-card" style="text-decoration:none;">
                        <div class="action-icon">
                            <i class="fas fa-envelope-open-text"></i>
                        </div>
                        <div class="action-title">Generate Follow-ups</div>
                        <div class="action-desc">Find leads without recent outreach and draft emails.</div>
                    </a>

                    <a href="/lead-management/public/app/leads?filter=behavior_watchlist"
                       class="action-card" style="text-decoration:none;">
                        <div class="action-icon">
                            <i class="fas fa-brain"></i>
                        </div>
                        <div class="action-title">Behavior Watchlist</div>
                        <div class="action-desc">Identify leads with unusual or high-intent activity.</div>
                    </a>
                </div>
            </section>
        </div>

        <!-- Right column -->
        <div class="right-column">
            <!-- Email Templates / Presets -->
            <section class="quick-actions-section">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-envelope"></i>
                        AI Email Presets
                    </h2>
                </div>

                <p style="margin-bottom:1rem;color:var(--sky-700);">
                    These presets are used when you click <strong>"Generate AI Email"</strong> in Lead details.
                    You can change them later in settings if you add a dedicated table.
                </p>

                <div class="quick-actions-grid">
                    <div class="action-card">
                        <div class="action-icon">
                            <i class="fas fa-handshake"></i>
                        </div>
                        <div class="action-title">Warm Follow-up</div>
                        <div class="action-desc">Friendly nudge after form submission or demo request.</div>
                    </div>

                    <div class="action-card">
                        <div class="action-icon">
                            <i class="fas fa-calendar-check"></i>
                        </div>
                        <div class="action-title">Book a Meeting</div>
                        <div class="action-desc">Call-to-action focused on scheduling a call or demo.</div>
                    </div>

                    <div class="action-card">
                        <div class="action-icon">
                            <i class="fas fa-undo-alt"></i>
                        </div>
                        <div class="action-title">Re-engagement</div>
                        <div class="action-desc">Win-back email for leads that went quiet.</div>
                    </div>

                    <div class="action-card">
                        <div class="action-icon">
                            <i class="fas fa-list-check"></i>
                        </div>
                        <div class="action-title">Qualification</div>
                        <div class="action-desc">Ask clarifying questions to qualify intent & budget.</div>
                    </div>
                </div>
            </section>

            <!-- Recent AI Activity (static shell for now) -->
            <section class="deadlines-section">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-history"></i>
                        Recent AI Activity
                    </h2>
                </div>

                <div class="deadlines-list">
                    <div class="deadline-item">
                        <div class="deadline-icon">
                            <i class="fas fa-star-half-alt"></i>
                        </div>
                        <div class="deadline-content">
                            <div class="deadline-title">Lead scoring batch</div>
                            <div class="deadline-date">
                                <i class="fas fa-calendar"></i>
                                Last run: just now (shell UI – hook to logs later)
                            </div>
                        </div>
                        <div class="deadline-urgency urgency-low">Info</div>
                    </div>

                    <div class="deadline-item">
                        <div class="deadline-icon">
                            <i class="fas fa-envelope-open"></i>
                        </div>
                        <div class="deadline-content">
                            <div class="deadline-title">Emails generated</div>
                            <div class="deadline-date">
                                <i class="fas fa-calendar"></i>
                                5 follow-ups created in the last hour
                            </div>
                        </div>
                        <div class="deadline-urgency urgency-medium">Medium</div>
                    </div>

                    <div class="deadline-item">
                        <div class="deadline-icon">
                            <i class="fas fa-brain"></i>
                        </div>
                        <div class="deadline-content">
                            <div class="deadline-title">Behavior insights</div>
                            <div class="deadline-date">
                                <i class="fas fa-calendar"></i>
                                3 leads flagged for high-intent activity
                            </div>
                        </div>
                        <div class="deadline-urgency urgency-high">High</div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const saveBtn   = document.getElementById('save-ai-config-btn');
    const testBtn   = document.getElementById('test-ai-config-btn');
    const statusEl  = document.getElementById('ai-config-status');
    const providerEl = document.getElementById('ai_provider');
    const apiKeyEl   = document.getElementById('api_key');

    if (!saveBtn || !statusEl) return;

    function setStatus(message, type) {
        if (!statusEl) return;
        statusEl.textContent = message;
        statusEl.style.color = type === 'error'
            ? 'var(--danger)'
            : 'var(--success)';
    }

    saveBtn.addEventListener('click', async function () {
        const payload = {
            ai_provider: providerEl.value,
            api_key: apiKeyEl.value
        };

        try {
            setStatus('Saving configuration...', 'info');
            const res = await fetch('/lead-management/public/api/config/ai', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(payload)
            });

            const data = await res.json();
            if (data.success) {
                setStatus('AI configuration saved successfully.', 'success');
            } else {
                setStatus(data.error || 'Failed to save configuration.', 'error');
            }
        } catch (e) {
            setStatus('Error saving configuration: ' + e.message, 'error');
        }
    });

    // "Test connection" is a visual-only stub for now
    if (testBtn) {
        testBtn.addEventListener('click', function () {
            setStatus('Test request sent. (Wire this to a /api/ai/test endpoint when ready.)', 'success');
        });
    }
});
</script>
