<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Airunner • AI-Powered Lead Management' ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        /* Your beautiful CSS from the provided HTML */
        :root {
            --bg-grad: linear-gradient(135deg, #7865f3 0%, #6a6be9 35%, #6a58d6 65%, #8a53d6 100%);
            --card: #ffffff;
            --ink: #0f172a;
            --muted: #475569;
            --primary: #635bff;
            --primary-2: #7c3aed;
            --accent: #10b981;
            --warn: #f59e0b;
            --danger: #ef4444;
            --ring: 0 10px 25px rgba(99, 91, 255, 0.25);
            --shadow: 0 12px 30px rgba(2, 6, 23, 0.08);
            --radius: 16px;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        html,
        body {
            height: 100%;
            scroll-behavior: smooth;
        }

        body {
            font-family: Inter, system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, 'Helvetica Neue', Arial, sans-serif;
            color: var(--ink);
            background: #0b1020;
            overflow-x: hidden;
        }

        /* Add all your beautiful CSS styles from the provided HTML here */
        /* ... (copy all the CSS from your provided HTML) ... */

        /* Additional styles for the lead capture form */
        .lead-form {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 12px;
            padding: 2rem;
            margin: 2rem 0;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .form-group {
            margin-bottom: 1rem;
        }

        .form-group label {
            display: block;
            color: #cbd5e1;
            margin-bottom: 0.5rem;
            font-weight: 500;
        }

        .form-control {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 8px;
            background: rgba(255, 255, 255, 0.1);
            color: white;
            font-size: 1rem;
        }

        .form-control:focus {
            outline: none;
            border-color: #7c3aed;
            box-shadow: 0 0 0 3px rgba(124, 58, 237, 0.1);
        }

        .form-message {
            margin-top: 1rem;
            padding: 0.75rem;
            border-radius: 8px;
            display: none;
        }

        .form-message.success {
            background: rgba(16, 185, 129, 0.1);
            border: 1px solid rgba(16, 185, 129, 0.3);
            color: #10b981;
        }

        .form-message.error {
            background: rgba(239, 68, 68, 0.1);
            border: 1px solid rgba(239, 68, 68, 0.3);
            color: #ef4444;
        }
    </style>
</head>

<body>
    <?= $content ?? '' ?>

    <script>
        // Your JavaScript from the provided HTML
        // ... (copy all the JavaScript from your provided HTML) ...

        // Additional JavaScript for lead capture form
        document.addEventListener('DOMContentLoaded', function() {
            const leadForm = document.getElementById('leadForm');
            if (leadForm) {
                leadForm.addEventListener('submit', async function(e) {
                    e.preventDefault();

                    const submitBtn = this.querySelector('button[type="submit"]');
                    const originalText = submitBtn.textContent;
                    const messageDiv = document.getElementById('formMessage');

                    // Show loading state
                    submitBtn.disabled = true;
                    submitBtn.textContent = 'Sending...';
                    messageDiv.style.display = 'none';

                    try {
                        const formData = new FormData(this);
                        const response = await fetch('/lead-management/public/landing/capture', {
                            method: 'POST',
                            body: formData
                        });

                        const result = await response.json();

                        if (result.success) {
                            messageDiv.textContent = result.message;
                            messageDiv.className = 'form-message success';
                            messageDiv.style.display = 'block';
                            this.reset();
                        } else {
                            messageDiv.textContent = result.message;
                            messageDiv.className = 'form-message error';
                            messageDiv.style.display = 'block';
                        }
                    } catch (error) {
                        messageDiv.textContent = 'Network error. Please try again.';
                        messageDiv.className = 'form-message error';
                        messageDiv.style.display = 'block';
                    } finally {
                        submitBtn.disabled = false;
                        submitBtn.textContent = originalText;
                    }
                });
            }
        });
    </script>
    <script type="module" src="/lead-management/public/assets/js/main.js"></script>

</body>

</html>