<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title ?? 'LeadIntelligence AI') ?></title>
    <link rel="stylesheet" href="<?= $baseUrl ?? '' ?>/assets/css/styles.css">
</head>

<body>
    <!-- Main Header -->
    <header class="main-header">
        <div class="header-container">
            <div class="header-brand">
                <a href="<?= $baseUrl ?? '' ?>/" class="brand-link">
                    <span class="brand-logo">🧠</span>
                    <span class="brand-text">LeadIntelligence AI</span>
                </a>
            </div>

            <nav class="header-nav">
                <a href="<?= $baseUrl ?? '' ?>/" class="nav-link">Home</a>
                <a href="<?= $baseUrl ?? '' ?>/features" class="nav-link">Features</a>
                <a href="<?= $baseUrl ?? '' ?>/pricing" class="nav-link">Pricing</a>
                <a href="<?= $baseUrl ?? '' ?>/about" class="nav-link">About</a>

                <?php if (!empty($_SESSION['user_id'])): ?>
                    <!-- Logged in user menu -->
                    <div class="user-menu">
                        <a href="<?= $baseUrl ?? '' ?>/app" class="nav-link nav-button">Dashboard</a>
                        <a href="<?= $baseUrl ?? '' ?>/profile" class="nav-link">Profile</a>
                        <a href="<?= $baseUrl ?? '' ?>/logout" class="nav-link nav-button-outline">Logout</a>
                    </div>
                <?php else: ?>
                    <!-- Guest user menu -->
                    <div class="auth-menu">
                        <a href="<?= $baseUrl ?? '' ?>/login" class="nav-link">Sign In</a>
                        <a href="<?= $baseUrl ?? '' ?>/register" class="nav-link nav-button">Get Started Free</a>
                    </div>
                <?php endif; ?>
            </nav>
        </div>
    </header>

    <!-- Main Content -->
    <div class="main-content"></div>