<?php include VIEWS_PATH . '/layouts/auth-header.php'; ?>

<main class="auth-main">
    <div class="auth-container">
        <div class="auth-card login">
            <div class="auth-card-header">
                <h1 class="auth-title">Sign in to your account</h1>
                <p class="auth-subtitle">
                    Or <a href="<?= $baseUrl ?? '' ?>/register" class="auth-link-primary">create a new account</a>
                </p>
            </div>

            <?php if (isset($error)): ?>
                <div class="form-error">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <?php if (isset($success)): ?>
                <div class="form-success">
                    <?= htmlspecialchars($success) ?>
                </div>
            <?php endif; ?>

            <form class="auth-form" action="<?= $baseUrl ?? '' ?>/login" method="POST">
                <div class="form-group">
                    <label for="email" class="form-label">
                        Email Address
                    </label>
                    <input id="email" name="email" type="email" required
                           placeholder="Enter your email address"
                           value="<?= htmlspecialchars($old['email'] ?? '') ?>"
                           class="form-input">
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">
                        Password
                    </label>
                    <input id="password" name="password" type="password" required
                           placeholder="Enter your password"
                           class="form-input">
                </div>

                <div class="login-options">
                    <div class="checkbox-group" style="margin: 0;">
                        <input id="remember_me" name="remember_me" type="checkbox"
                               class="checkbox-input" <?= isset($old['remember_me']) ? 'checked' : '' ?>>
                        <label for="remember_me" class="checkbox-label">
                            Remember me for 30 days
                        </label>
                    </div>
                    <a href="<?= $baseUrl ?? '' ?>/forgot-password" class="forgot-password">
                        Forgot your password?
                    </a>
                </div>

                <button type="submit" class="auth-button">
                    Sign In
                </button>
            </form>

            <div class="auth-links">
                <p class="auth-text-muted">
                    Don't have an account? 
                    <a href="<?= $baseUrl ?? '' ?>/register" class="auth-link-primary">Sign up</a>
                </p>
                <p class="auth-text-muted auth-mt-4">
                    <a href="<?= $baseUrl ?? '' ?>/" class="auth-link-primary">← Back to Home</a>
                </p>
            </div>
        </div>
    </div>
</main>

<?php include VIEWS_PATH . '/layouts/auth-footer.php'; ?>