<?php

use App\Controllers\DashboardController;
use App\Controllers\LeadController;
use App\Controllers\AIController;
use App\Controllers\ConfigController;
use App\Controllers\HomeController;

return [
    // Landing page routes
    'GET /' => [HomeController::class, 'index'],
    'POST /landing/capture' => [HomeController::class, 'captureLead'],

    // Main App Pages (require authentication in future)
    'GET /app' => [DashboardController::class, 'index'],
    'GET /app/forms' => [LeadController::class, 'forms'],
    'POST /app/forms/create' => [LeadController::class, 'createForm'],
    'GET /app/leads' => [LeadController::class, 'leads'],
    'GET /app/ai-tools' => [AIController::class, 'index'],

    // API Routes
    'POST /api/lead' => [LeadController::class, 'capture'],
    'POST /api/ai/analyze' => [AIController::class, 'analyze'],
    'POST /api/ai/response' => [AIController::class, 'generateResponse'],
    'POST /api/config/ai' => [ConfigController::class, 'saveAIConfig'],
    'POST /api/config/template' => [ConfigController::class, 'saveTemplate'],
    'GET /api/ai/status' => [ConfigController::class, 'checkAIStatus'],
    'GET /api/lead' => [LeadController::class, 'getLead'],
    'GET /api/leads/search' => [LeadController::class, 'searchLeads'],

    // Debug route
    'GET /debug' => function () {
        echo "Debug: Routes are working!";
        exit;
    },
];
