// ====== Footer Component Functionality ======

import { $, $$, domReady } from '../core/helpers.js';

class FooterManager {
    constructor() {
        this.footer = null;
        this.init();
    }

    async init() {
        await domReady();
        this.setupFooter();
        this.setupCurrentYear();
        this.setupSocialLinks();
    }

    setupFooter() {
        this.footer = $('.auth-footer');
        if (!this.footer) return;
    }

    setupCurrentYear() {
        const yearElements = $$('.current-year');
        const currentYear = new Date().getFullYear();
        
        yearElements.forEach(element => {
            element.textContent = currentYear;
        });
    }

    setupSocialLinks() {
        const socialLinks = $$('.social-link');
        
        socialLinks.forEach(link => {
            link.addEventListener('click', (e) => {
                e.preventDefault();
                const platform = link.getAttribute('aria-label')?.toLowerCase();
                this.trackSocialClick(platform);
                
                // Open in new tab for external links
                const url = link.getAttribute('href');
                if (url && url.startsWith('http')) {
                    window.open(url, '_blank', 'noopener,noreferrer');
                }
            });
        });
    }

    trackSocialClick(platform) {
        // Track social media clicks for analytics
        if (typeof gtag !== 'undefined') {
            gtag('event', 'social_click', {
                event_category: 'Social',
                event_label: platform
            });
        }
        
        console.log(`Social link clicked: ${platform}`);
    }

    // Lazy load social media widgets
    loadSocialWidgets() {
        // This would load Twitter timelines, Facebook widgets, etc.
        // Only load when footer is in viewport for performance
    }
}

// Create and initialize footer manager
export const footerManager = new FooterManager();