<div class="space-y-6">
    <div class="flex items-center justify-between gap-3">
        <div>
            <h1 class="text-xl font-semibold text-slate-900">
                <?= htmlspecialchars($task['title']) ?>
            </h1>
            <p class="mt-1 text-sm text-slate-600">
                Task details and context.
            </p>
        </div>
        <div class="flex gap-2">
            <a href="/lead-management/public/app/tasks/<?= (int)$task['id'] ?>/edit"
               class="inline-flex items-center rounded-md bg-sky-600 px-3 py-2 text-sm font-medium text-white shadow-sm hover:bg-sky-700">
                Edit
            </a>
            <a href="/lead-management/public/app/tasks"
               class="inline-flex items-center rounded-md border border-slate-200 bg-white px-3 py-2 text-sm font-medium text-slate-700 hover:bg-slate-50">
                Back
            </a>
        </div>
    </div>

    <div class="grid gap-6 md:grid-cols-3">
        <!-- Left: main content -->
        <div class="md:col-span-2 space-y-4">
            <div class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm">
                <h2 class="text-sm font-semibold text-slate-900 mb-2">Description</h2>
                <p class="text-sm text-slate-700 whitespace-pre-line">
                    <?= $task['description']
                        ? htmlspecialchars($task['description'])
                        : 'No description provided.' ?>
                </p>
            </div>
        </div>

        <!-- Right: meta -->
        <div class="space-y-4">
            <div class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm space-y-3">
                <h2 class="text-sm font-semibold text-slate-900">Meta</h2>

                <div class="flex items-center justify-between text-sm">
                    <span class="text-slate-500">Status</span>
                    <span class="font-medium text-slate-800">
                        <?= ucwords(str_replace('_', ' ', $task['status'] ?? 'pending')) ?>
                    </span>
                </div>

                <div class="flex items-center justify-between text-sm">
                    <span class="text-slate-500">Priority</span>
                    <span class="font-medium text-slate-800">
                        <?= ucfirst($task['priority'] ?? 'medium') ?>
                    </span>
                </div>

                <div class="flex items-center justify-between text-sm">
                    <span class="text-slate-500">Due date</span>
                    <span class="font-medium text-slate-800">
                        <?php if (!empty($task['due_date'])): ?>
                            <?= htmlspecialchars(date('M j, Y', strtotime($task['due_date']))) ?>
                        <?php else: ?>
                            <span class="text-slate-400">No due date</span>
                        <?php endif; ?>
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>
