<?php
// Expected: $lead = single lead row from LeadsController@edit($id)
if (!isset($lead)) {
    $lead = [];
}
$id         = $lead['id'] ?? null;
$firstName  = $lead['first_name'] ?? '';
$lastName   = $lead['last_name'] ?? '';
$email      = $lead['email'] ?? '';
$phone      = $lead['phone'] ?? '';
$status     = $lead['status'] ?? 'new';
$aiScore    = $lead['ai_score'] ?? $lead['score'] ?? '';
$notes      = $lead['notes'] ?? '';
?>
<div class="dashboard-container">
    <header class="page-header">
        <div>
            <div class="page-header-title">
                Edit Lead <?= htmlspecialchars($firstName . ' ' . $lastName ?: '#'.$id) ?>
            </div>
            <div class="page-header-subtitle">
                Update lead details and status.
            </div>
        </div>
    </header>

    <section class="form-card">
        <form action="/lead-management/public/app/leads/<?= (int)$id ?>/update" method="POST">
            <div class="form-grid">
                <div class="form-field">
                    <label for="first_name">First Name</label>
                    <input id="first_name" name="first_name"
                           type="text" value="<?= htmlspecialchars($firstName) ?>" required>
                </div>
                <div class="form-field">
                    <label for="last_name">Last Name</label>
                    <input id="last_name" name="last_name"
                           type="text" value="<?= htmlspecialchars($lastName) ?>">
                </div>

                <div class="form-field">
                    <label for="email">Email</label>
                    <input id="email" name="email"
                           type="email" value="<?= htmlspecialchars($email) ?>">
                </div>
                <div class="form-field">
                    <label for="phone">Phone</label>
                    <input id="phone" name="phone"
                           type="text" value="<?= htmlspecialchars($phone) ?>">
                </div>

                <div class="form-field">
                    <label for="status">Status</label>
                    <select id="status" name="status">
                        <?php
                        $statuses = ['new' => 'New', 'open' => 'Open', 'won' => 'Won', 'lost' => 'Lost'];
                        foreach ($statuses as $value => $label):
                        ?>
                            <option value="<?= $value ?>" <?= $status === $value ? 'selected' : '' ?>>
                                <?= $label ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-field">
                    <label for="ai_score">AI Score</label>
                    <input id="ai_score" name="ai_score"
                           type="number" min="0" max="100"
                           value="<?= htmlspecialchars($aiScore) ?>">
                </div>

                <div class="form-field" style="grid-column: 1 / -1;">
                    <label for="notes">Notes</label>
                    <textarea id="notes" name="notes" rows="3"><?= htmlspecialchars($notes) ?></textarea>
                </div>
            </div>

            <div class="form-actions">
                <button type="button" class="btn-secondary"
                        onclick="window.location.href='/lead-management/public/app/leads'">
                    Cancel
                </button>
                <button type="submit" class="btn-primary">
                    Update Lead
                </button>
            </div>
        </form>
    </section>
</div>
