<?php
// Expected: $forms = array from FormsController@index()
// Common fields: id, name/title, status, created_at, submissions_count (if available)
?>
<div class="dashboard-container">
    <style>
        .forms-card {
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.98), rgba(240, 249, 255, 0.98));
            border-radius: 16px;
            padding: 1.75rem;
            box-shadow: 0 8px 24px rgba(15, 23, 42, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.9);
        }

        .forms-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .forms-header h2 {
            font-size: 1.3rem;
            font-weight: 700;
            color: var(--sky-800);
            display: flex;
            align-items: center;
            gap: .5rem;
        }

        .status-pill-open {
            background: rgba(16, 185, 129, 0.08);
            color: #059669;
        }

        .status-pill-draft {
            background: rgba(245, 158, 11, 0.08);
            color: #c2410c;
        }

        .status-pill-closed {
            background: rgba(148, 163, 184, 0.16);
            color: #475569;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.9rem;
            margin-top: 0.5rem;
        }

        .data-table thead {
            background: var(--sky-50);
        }

        .data-table th,
        .data-table td {
            padding: 0.6rem 0.75rem;
            text-align: left;
        }

        .data-table th {
            font-size: 0.8rem;
            letter-spacing: .06em;
            text-transform: uppercase;
            color: var(--sky-700);
            border-bottom: 1px solid var(--sky-200);
        }

        .data-table tbody tr {
            background: rgba(255, 255, 255, 0.95);
            border-bottom: 1px solid var(--sky-100);
            transition: var(--transition);
        }

        .data-table tbody tr:hover {
            background: var(--sky-50);
        }

        .empty-state {
            text-align: center;
            padding: 2rem;
            color: var(--sky-700);
            font-size: 0.95rem;
        }

        @media (max-width: 768px) {
            .data-table {
                display: block;
                overflow-x: auto;
            }
        }
    </style>

    <header class="page-header">
        <div>
            <div class="page-header-title">Forms</div>
            <div class="page-header-subtitle">
                Manage lead capture forms and track their performance.
            </div>
        </div>
        <div class="page-header-actions">
            <button class="btn-primary" type="button"
                onclick="window.location.href='/lead-management/public/app/forms/create'">
                <i class="fas fa-pen-to-square"></i> New Form
            </button>
        </div>
    </header>

    <section class="forms-card">
        <div class="forms-header">
            <h2><i class="fas fa-clipboard-list"></i> All Forms</h2>
        </div>

        <?php if (empty($forms)): ?>
            <div class="empty-state">
                No forms yet. Create your first form to start capturing leads.
            </div>
        <?php else: ?>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Form</th>
                        <th>Status</th>
                        <th>Submissions</th>
                        <th>Created</th>
                        <th style="text-align:right;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($forms as $form): ?>
                        <?php
                        $id    = $form['id'] ?? null;
                        $name  = $form['name'] ?? $form['title'] ?? ('Form #' . $id);
                        $status = strtolower($form['status'] ?? 'draft');
                        $createdAt = $form['created_at'] ?? '';
                        $subCount  = $form['submissions_count'] ?? $form['submission_count'] ?? 0;

                        $statusClass = 'status-pill';
                        if ($status === 'open' || $status === 'active' || $status === 'live') {
                            $statusClass .= ' status-pill-open';
                        } elseif ($status === 'closed') {
                            $statusClass .= ' status-pill-closed';
                        } else {
                            $statusClass .= ' status-pill-draft';
                        }
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($name) ?></td>
                            <td><span class="<?= $statusClass ?>"><?= htmlspecialchars(ucfirst($status)) ?></span></td>
                            <td><?= (int)$subCount ?></td>
                            <td><?= htmlspecialchars($createdAt) ?></td>
                            <td style="text-align:right;">
                                <?php if ($id): ?>
                                    <button type="button" class="btn-link"
                                        onclick="window.location.href='/lead-management/public/app/forms/<?= (int)$id ?>/edit'">
                                        Edit
                                    </button>
                                    <button type="button" class="btn-link"
                                        onclick="window.location.href='/lead-management/public/app/forms/<?= (int)$id ?>/submissions'">
                                        Submissions
                                    </button>
                                    <button type="button" class="btn-link"
                                        onclick="window.location.href='/lead-management/public/app/forms/<?= (int)$id ?>/analytics'">
                                        Analytics
                                    </button>
                                    <button type="button" class="btn-link btn-link-danger"
                                        onclick="if(confirm('Delete this form?')){ window.location.href='/lead-management/public/app/forms/<?= (int)$id ?>/delete'; }">
                                        Delete
                                    </button>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </section>
</div>