<?php
// Expected from controller (flexible):
// $form       = form row
// $stats      = ['views' => ..., 'submissions' => ..., 'conversion_rate' => ..., 'today' => ..., 'last_30_days' => ...]
// $dailyStats = array of ['date' => 'YYYY-MM-DD', 'count' => n] for simple chart (optional)
$formName = $form['name'] ?? ($form['title'] ?? ('Form #'.($form['id'] ?? '')));
$stats = $stats ?? [];
$views = $stats['views'] ?? $stats['total_views'] ?? null;
$subs  = $stats['submissions'] ?? $stats['total_submissions'] ?? null;
$conv  = $stats['conversion_rate'] ?? null;
$today = $stats['submissions_today'] ?? $stats['today'] ?? null;
$last30 = $stats['last_30_days'] ?? $stats['submissions_30d'] ?? null;
$dailyStats = $dailyStats ?? [];
?>
<div class="dashboard-container">
    <style>
        .page-header {
            background: rgba(255,255,255,0.9);
            backdrop-filter: blur(18px);
            border-radius: 16px;
            padding: 1.5rem 2rem;
            margin-bottom: 1.5rem;
            box-shadow: 0 8px 20px rgba(15, 23, 42, 0.08);
            border: 1px solid rgba(255,255,255,0.9);
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1rem;
        }
        .page-header-title {
            font-size: 1.6rem;
            font-weight: 700;
            color: var(--sky-800);
        }
        .page-header-subtitle {
            color: var(--sky-700);
            font-size: 0.95rem;
        }
        .page-header-actions .btn-primary {
            padding: 0.6rem 1.3rem;
            background: var(--primary);
            color: #fff;
            border: none;
            border-radius: 999px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }
        .page-header-actions .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
            box-shadow: 0 8px 18px rgba(37,99,235,0.35);
        }

        .analytics-grid {
            display: grid;
            grid-template-columns: 2fr 1.2fr;
            gap: 1.5rem;
        }
        @media (max-width:1024px) {
            .analytics-grid {
                grid-template-columns: 1fr;
            }
        }

        .card {
            background: linear-gradient(135deg, rgba(255,255,255,0.98), rgba(240,249,255,0.98));
            border-radius: 16px;
            padding: 1.5rem 1.75rem;
            box-shadow: 0 8px 24px rgba(15,23,42,0.08);
            border: 1px solid rgba(255,255,255,0.9);
            position: relative;
            overflow: hidden;
        }
        .card::before {
            content: "";
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 4px;
            background: linear-gradient(90deg, var(--primary-light), var(--primary));
            background-size: 200% 100%;
            animation: gradientShift 4s ease infinite;
        }
        .card h2 {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--sky-800);
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .metrics-grid {
            display: grid;
            grid-template-columns: repeat(4, minmax(0,1fr));
            gap: 1rem;
            margin-bottom: 1rem;
        }
        @media (max-width:900px) {
            .metrics-grid {
                grid-template-columns: repeat(2, minmax(0,1fr));
            }
        }
        .metric {
            background: rgba(255,255,255,0.9);
            border-radius: 12px;
            padding: 0.8rem 0.9rem;
            border: 1px solid var(--sky-100);
        }
        .metric-label {
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: .06em;
            color: var(--sky-600);
            margin-bottom: 0.25rem;
        }
        .metric-value {
            font-size: 1.2rem;
            font-weight: 800;
            color: var(--sky-900);
        }

        .chart-wrapper {
            margin-top: 1rem;
        }
        .chart-bars {
            display: flex;
            align-items: flex-end;
            gap: 0.4rem;
            height: 160px;
            padding-bottom: 0.5rem;
        }
        .chart-bar {
            flex: 1;
            border-radius: 10px 10px 0 0;
            background: linear-gradient(180deg, var(--primary), var(--primary-light));
            position: relative;
            overflow: hidden;
        }
        .chart-bar-inner {
            position: absolute;
            bottom: 0; left: 0; right: 0;
            transform-origin: bottom;
            transform: scaleY(0);
            background: linear-gradient(180deg, var(--primary-light), var(--primary));
        }
        .chart-bar-labels {
            display: flex;
            justify-content: space-between;
            gap: 0.4rem;
            font-size: 0.7rem;
            color: var(--sky-700);
        }

        .secondary-card::before {
            background: linear-gradient(90deg, var(--sky-400), var(--sky-600));
        }
        .list {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
            font-size: 0.85rem;
            color: var(--sky-800);
        }
        .list-item-label {
            font-weight: 600;
        }

        @keyframes gradientShift {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
    </style>

    <header class="page-header">
        <div>
            <div class="page-header-title">
                Analytics – <?= htmlspecialchars($formName) ?>
            </div>
            <div class="page-header-subtitle">
                Conversion and submission trends for this form (based on your dev data).
            </div>
        </div>
        <div class="page-header-actions">
            <button type="button" class="btn-primary"
                    onclick="window.location.href='/lead-management/public/app/forms'">
                ← Back to Forms
            </button>
        </div>
    </header>

    <div class="analytics-grid">
        <!-- Left: main stats & chart -->
        <section class="card">
            <h2><i class="fas fa-chart-line"></i> Performance Overview</h2>
            <div class="metrics-grid">
                <div class="metric">
                    <div class="metric-label">Views</div>
                    <div class="metric-value"><?= $views !== null ? (int)$views : '—' ?></div>
                </div>
                <div class="metric">
                    <div class="metric-label">Submissions</div>
                    <div class="metric-value"><?= $subs !== null ? (int)$subs : '—' ?></div>
                </div>
                <div class="metric">
                    <div class="metric-label">Conversion</div>
                    <div class="metric-value">
                        <?= $conv !== null ? htmlspecialchars(number_format((float)$conv, 1) . '%') : '—' ?>
                    </div>
                </div>
                <div class="metric">
                    <div class="metric-label">Today</div>
                    <div class="metric-value"><?= $today !== null ? (int)$today : '—' ?></div>
                </div>
            </div>

            <div class="chart-wrapper">
                <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:0.5rem;">
                    <div style="font-size:0.9rem;font-weight:600;color:var(--sky-800);">
                        Last 14 days submissions
                    </div>
                    <div style="font-size:0.8rem;color:var(--sky-600);">
                        Using your live dev stats (if provided)
                    </div>
                </div>

                <?php if (!empty($dailyStats)): ?>
                    <?php
                        // Normalize data in PHP
                        $points = $dailyStats;
                        // Limit to last 14 points just in case
                        if (count($points) > 14) {
                            $points = array_slice($points, -14);
                        }
                        $maxCount = 0;
                        foreach ($points as $p) {
                            $c = (int)($p['count'] ?? $p['submissions'] ?? 0);
                            if ($c > $maxCount) $maxCount = $c;
                        }
                    ?>
                    <div class="chart-bars" id="analytics-bars"
                         data-max="<?= $maxCount ?>">
                        <?php foreach ($points as $p): ?>
                            <?php $c = (int)($p['count'] ?? $p['submissions'] ?? 0); ?>
                            <div class="chart-bar" data-count="<?= $c ?>">
                                <div class="chart-bar-inner"></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="chart-bar-labels">
                        <?php foreach ($points as $p): ?>
                            <?php
                                $label = $p['date'] ?? $p['day'] ?? '';
                                // show short label
                                $label = substr((string)$label, 5); // MM-DD from YYYY-MM-DD
                            ?>
                            <span><?= htmlspecialchars($label) ?></span>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div style="padding:1.25rem 0; font-size:0.9rem; color:var(--sky-700);">
                        No daily stats provided by controller yet.  
                        You can pass <code>$dailyStats = [['date' => '2025-11-01','count' => 5], ...]</code>
                        from <code>FormsController@analytics</code> to render a mini chart here.
                    </div>
                <?php endif; ?>
            </div>
        </section>

        <!-- Right: secondary metrics / breakdown -->
        <section class="card secondary-card">
            <h2><i class="fas fa-clipboard-check"></i> Breakdown</h2>
            <div class="list">
                <div>
                    <div class="list-item-label">Submissions (last 30 days)</div>
                    <div><?= $last30 !== null ? (int)$last30 : '—' ?></div>
                </div>
                <div>
                    <div class="list-item-label">Form ID</div>
                    <div><?= htmlspecialchars((string)($form['id'] ?? '—')) ?></div>
                </div>
                <div>
                    <div class="list-item-label">Status</div>
                    <div><?= htmlspecialchars(ucfirst($form['status'] ?? 'unknown')) ?></div>
                </div>
                <?php if (!empty($form['created_at'])): ?>
                    <div>
                        <div class="list-item-label">Created at</div>
                        <div><?= htmlspecialchars($form['created_at']) ?></div>
                    </div>
                <?php endif; ?>
                <?php if (!empty($form['updated_at'])): ?>
                    <div>
                        <div class="list-item-label">Last updated</div>
                        <div><?= htmlspecialchars($form['updated_at']) ?></div>
                    </div>
                <?php endif; ?>

                <?php if (!empty($stats) && is_array($stats)): ?>
                    <div>
                        <div class="list-item-label">Raw stats (debug)</div>
                        <pre style="margin-top:0.25rem;font-size:0.7rem;max-height:150px;overflow:auto;background:rgba(15,23,42,0.02);padding:0.5rem;border-radius:8px;border:1px solid var(--sky-100);">
<?= htmlspecialchars(json_encode($stats, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE)) ?>
                        </pre>
                    </div>
                <?php endif; ?>
            </div>
        </section>
    </div>
</div>

<script>
    // Animate simple bar chart from data-count attributes
    document.addEventListener('DOMContentLoaded', function () {
        const barsContainer = document.getElementById('analytics-bars');
        if (!barsContainer) return;
        const max = parseInt(barsContainer.dataset.max || '0', 10) || 0;
        const bars = barsContainer.querySelectorAll('.chart-bar');

        if (!max || bars.length === 0) return;

        bars.forEach(bar => {
            const count = parseInt(bar.dataset.count || '0', 10);
            const heightPct = max === 0 ? 0 : (count / max) * 100;
            const inner = bar.querySelector('.chart-bar-inner');
            if (!inner) return;
            // delay so CSS animation is visible
            setTimeout(() => {
                inner.style.height = heightPct + '%';
                inner.style.transform = 'scaleY(1)';
            }, 200);
        });
    });
</script>
