<?php
// SkyBlue Global Analytics page
// Expects: $stats, $trends, $formsOverview, $recentActivity, $conversion
$trends        = $trends        ?? [];
$formsOverview = $formsOverview ?? [];
$recentActivity = $recentActivity ?? [];
$conversion    = $conversion    ?? [];

$maxSubmissions = 0;
foreach ($trends as $t) {
    $cnt = (int)($t['submissions'] ?? 0);
    if ($cnt > $maxSubmissions) {
        $maxSubmissions = $cnt;
    }
}
$maxSubmissions = max($maxSubmissions, 1);
?>
<div class="dashboard-container">
    <!-- Header -->
    <header class="dashboard-header">
        <div class="header-content">
            <div class="welcome-section">
                <h1>Analytics & Insights</h1>
                <p>Track performance across forms, leads, and AI scoring.</p>
            </div>
        </div>

        <!-- Quick stats -->
        <div class="quick-stats">
            <div class="stat-card">
                <div class="stat-number">
                    <?= number_format((int)($stats['total_leads'] ?? 0)) ?>
                </div>
                <div class="stat-label">Total Leads</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">
                    <?= number_format((int)($stats['leads_today'] ?? 0)) ?>
                </div>
                <div class="stat-label">New Leads Today</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">
                    <?= number_format((int)($stats['high_score_leads'] ?? 0)) ?>
                </div>
                <div class="stat-label">High Priority (AI ≥ 80)</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">
                    <?= number_format((int)($stats['total_forms'] ?? 0)) ?> /
                    <?= number_format((int)($stats['total_submissions'] ?? 0)) ?>
                </div>
                <div class="stat-label">Forms / Submissions</div>
            </div>
        </div>
    </header>

    <!-- Main grid -->
    <div class="dashboard-grid">
        <!-- Left column -->
        <div class="left-column">
            <!-- Submission Trends -->
            <section class="tasks-section">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-chart-area"></i>
                        Submission Trends (Last 14 Days)
                    </h2>
                </div>

                <?php if (empty($trends)): ?>
                    <p style="color:var(--sky-700);">No submissions yet. Once you start receiving traffic, you’ll see daily charts here.</p>
                <?php else: ?>
                    <div style="display:flex;flex-direction:column;gap:0.75rem;">
                        <?php foreach ($trends as $t): 
                            $date  = htmlspecialchars($t['date'] ?? '');
                            $count = (int)($t['submissions'] ?? 0);
                            $width = round(($count / $maxSubmissions) * 100);
                        ?>
                            <div>
                                <div style="display:flex;justify-content:space-between;font-size:0.8rem;color:var(--sky-700);margin-bottom:0.15rem;">
                                    <span><?= $date ?></span>
                                    <span><?= $count ?> submissions</span>
                                </div>
                                <div style="height:8px;border-radius:10px;background:var(--sky-100);overflow:hidden;">
                                    <div style="
                                        width: <?= $width ?>%;
                                        height:100%;
                                        background: linear-gradient(90deg, var(--primary-light), var(--primary));
                                    "></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </section>

            <!-- Forms performance -->
            <section class="reports-section">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-file-alt"></i>
                        Forms Performance
                    </h2>
                </div>

                <?php if (empty($formsOverview)): ?>
                    <p style="color:var(--sky-700);">You don’t have any forms yet. Create one to start tracking performance.</p>
                <?php else: ?>
                    <div class="deadlines-list">
                        <?php foreach ($formsOverview as $f): ?>
                            <div class="deadline-item">
                                <div class="deadline-icon">
                                    <i class="fas fa-clipboard-list"></i>
                                </div>
                                <div class="deadline-content">
                                    <div class="deadline-title">
                                        <?= htmlspecialchars($f['name'] ?? 'Untitled Form') ?>
                                    </div>
                                    <div class="deadline-date">
                                        <i class="fas fa-chart-bar"></i>
                                        <?= (int)($f['submissions'] ?? 0) ?> submissions
                                    </div>
                                </div>
                                <div class="deadline-urgency urgency-low">
                                    <a href="/lead-management/public/app/forms/<?= (int)$f['id'] ?>/analytics"
                                       style="text-decoration:none;color:inherit;">
                                        View
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </section>
        </div>

        <!-- Right column -->
        <div class="right-column">
            <!-- Conversion & AI scoring -->
            <section class="progress-section">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-bullseye"></i>
                        Conversion & AI Scoring
                    </h2>
                </div>

                <div class="progress-list">
                    <div class="progress-item">
                        <div class="progress-header">
                            <div class="progress-label">Total Leads</div>
                            <div class="progress-value">
                                <?= number_format((int)($conversion['total_leads'] ?? 0)) ?>
                            </div>
                        </div>
                    </div>

                    <div class="progress-item">
                        <div class="progress-header">
                            <div class="progress-label">Converted Leads</div>
                            <div class="progress-value">
                                <?= number_format((int)($conversion['converted_leads'] ?? 0)) ?>
                            </div>
                        </div>
                    </div>

                    <div class="progress-item">
                        <div class="progress-header">
                            <div class="progress-label">Qualified Leads</div>
                            <div class="progress-value">
                                <?= number_format((int)($conversion['qualified_leads'] ?? 0)) ?>
                            </div>
                        </div>
                    </div>

                    <div class="progress-item">
                        <div class="progress-header">
                            <div class="progress-label">Avg AI Score</div>
                            <div class="progress-value">
                                <?= $conversion['avg_ai_score'] !== null ? $conversion['avg_ai_score'] : '—' ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Recent activity -->
            <section class="deadlines-section">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-history"></i>
                        Recent Activity
                    </h2>
                </div>

                <?php if (empty($recentActivity)): ?>
                    <p style="color:var(--sky-700);">No recent submissions yet.</p>
                <?php else: ?>
                    <div class="deadlines-list">
                        <?php foreach ($recentActivity as $item): ?>
                            <div class="deadline-item">
                                <div class="deadline-icon">
                                    <i class="fas fa-paper-plane"></i>
                                </div>
                                <div class="deadline-content">
                                    <div class="deadline-title">
                                        <?= htmlspecialchars($item['form_name'] ?? 'Form #'.(int)($item['form_id'] ?? 0)) ?>
                                    </div>
                                    <div class="deadline-date">
                                        <i class="fas fa-calendar"></i>
                                        <?= htmlspecialchars($item['created_at'] ?? '') ?>
                                    </div>
                                    <?php if (!empty($item['email'])): ?>
                                        <div class="deadline-date">
                                            <i class="fas fa-user"></i>
                                            <?= htmlspecialchars(trim(($item['first_name'] ?? '').' '.($item['last_name'] ?? ''))) ?>
                                            (<?= htmlspecialchars($item['email']) ?>)
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php if (!empty($item['lead_id'])): ?>
                                    <div class="deadline-urgency urgency-low">
                                        <a href="/lead-management/public/app/leads/<?= (int)$item['lead_id'] ?>"
                                           style="text-decoration:none;color:inherit;">
                                            View lead
                                        </a>
                                    </div>
                                <?php else: ?>
                                    <div class="deadline-urgency urgency-medium">
                                        No lead
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </section>
        </div>
    </div>
</div>
