<?php include VIEWS_PATH . '/layouts/auth-header.php'; ?>

<main class="auth-main">
    <div class="auth-container">
        <div class="auth-card reset">
            <div class="auth-card-header">
                <h1 class="auth-title">Create new password</h1>
                <p class="auth-subtitle">
                    Enter your new password below
                </p>
            </div>

            <?php if (isset($error)): ?>
                <div class="form-error">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <?php if (isset($success)): ?>
                <div class="form-success">
                    <?= htmlspecialchars($success) ?>
                </div>
            <?php endif; ?>

            <form class="auth-form" action="<?= $baseUrl ?? '' ?>/reset-password" method="post">
                <input type="hidden" name="token" value="<?= htmlspecialchars($token ?? '') ?>">
                
                <div class="form-group">
                    <label for="email" class="form-label">
                        Email Address
                    </label>
                    <input id="email" type="email" 
                           value="<?= htmlspecialchars($email ?? '') ?>"
                           class="form-input" disabled>
                    <div class="form-hint">This is the email associated with your account</div>
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">
                        New Password <span class="form-label-required">*</span>
                    </label>
                    <input id="password" name="password" type="password" required
                           placeholder="Enter your new password"
                           class="form-input">
                    <div class="form-hint">Minimum 8 characters with letters and numbers</div>
                </div>

                <div class="form-group">
                    <label for="confirm_password" class="form-label">
                        Confirm Password <span class="form-label-required">*</span>
                    </label>
                    <input id="confirm_password" name="confirm_password" type="password" required
                           placeholder="Confirm your new password"
                           class="form-input">
                </div>

                <button type="submit" class="auth-button">
                    Reset Password
                </button>
            </form>

            <div class="auth-links">
                <p class="auth-text-muted">
                    Remember your password? 
                    <a href="<?= $baseUrl ?? '' ?>/login" class="auth-link-primary">Back to login</a>
                </p>
            </div>
        </div>
    </div>
</main>

<?php include VIEWS_PATH . '/layouts/auth-footer.php'; ?>