<?php
// Tell the renderer we want a bare page (if honored); CSS below also hard-hides stray chrome.
$layout = 'no-header-footer';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>Register • LeadIntelligence AI</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <!-- Hard-hide any layout chrome that might be auto-injected -->
    <style id="auth-chrome-kill">
        /* Remove any header/footer that isn't ours */
        body>header:not(.auth-site-header),
        header.site-header:not(.auth-site-header),
        .global-header,
        #site-header {
            display: none !important;
        }

        body>footer:not(.auth-site-footer),
        footer.site-footer:not(.auth-site-footer),
        .marketing-footer,
        .global-footer,
        #site-footer {
            display: none !important;
        }
    </style>

    <link rel="stylesheet" href="<?= $baseUrl ?? '' ?>/assets/css/auth-compact.css?v=1.0">

</head>

<body>

    <!-- OUR header -->
    <header class="auth-site-header">
        <div class="auth-nav">
            <a class="auth-brand" href="<?= $baseUrl ?? '/' ?>">
                <span class="auth-brand-badge">🧠</span>
                <span>LeadIntelligence AI</span>
            </a>

            <nav class="auth-nav-links">
                <a href="<?= $baseUrl ?? '' ?>/#features">Features</a>
                <a href="<?= $baseUrl ?? '' ?>/#pricing">Pricing</a>
                <a href="<?= $baseUrl ?? '' ?>/#about">About</a>
            </nav>

            <div class="auth-nav-cta">
                <a class="auth-btn auth-btn-plain" href="<?= $baseUrl ?? '' ?>/login">Sign In</a>
                <a class="auth-btn auth-btn-primary" href="<?= $baseUrl ?? '' ?>/register">Get Started Free</a>
            </div>
        </div>
    </header>

    <main class="auth-main">
        <div class="auth-container">
            <div class="auth-card">
                <div class="auth-card-header">
                    <h1 class="auth-title">Create your account</h1>
                    <p class="auth-subtitle">Or <a href="<?= $baseUrl ?? '' ?>/login" class="auth-link-primary">sign in to your existing account</a></p>
                </div>

                <?php if (isset($error)): ?>
                    <div class="form-error"><?= htmlspecialchars($error) ?></div>
                <?php endif; ?>
                <?php if (isset($success)): ?>
                    <div class="form-success"><?= htmlspecialchars($success) ?></div>
                <?php endif; ?>

                <form class="auth-form" action="<?= $baseUrl ?? '' ?>/register" method="post" id="registerForm" novalidate>
                    <!-- Account Type -->
                    <div class="form-group">
                        <label class="form-label">Account Type <span class="form-label-required">*</span></label>
                        <div class="account-type-grid">
                            <label class="account-type-card <?= ($old['account_type'] ?? 'individual') === 'individual' ? 'selected' : '' ?>">
                                <span class="account-type-icon">👤</span>
                                <strong>Individual Account</strong>
                                <small>For personal use</small>
                                <input class="account-type-radio" type="radio" name="account_type" value="individual" <?= ($old['account_type'] ?? 'individual') === 'individual' ? 'checked' : '' ?> required>
                            </label>
                            <label class="account-type-card <?= ($old['account_type'] ?? '') === 'company' ? 'selected' : '' ?>">
                                <span class="account-type-icon">🏢</span>
                                <strong>Business Account</strong>
                                <small>For teams &amp; organizations</small>
                                <input class="account-type-radio" type="radio" name="account_type" value="company" <?= ($old['account_type'] ?? '') === 'company' ? 'checked' : '' ?> required>
                            </label>
                        </div>
                    </div>

                    <!-- Company -->
                    <div id="company-field" class="company-fields <?= ($old['account_type'] ?? 'individual') === 'company' ? 'active' : '' ?>">
                        <div class="form-group">
                            <label for="company_name" class="form-label">
                                Company Name
                                <span id="company-required" class="form-label-required" style="display: <?= ($old['account_type'] ?? 'individual') === 'company' ? 'inline' : 'none' ?>;">*</span>
                            </label>
                            <input id="company_name" name="company_name" type="text"
                                value="<?= htmlspecialchars($old['company_name'] ?? '') ?>"
                                placeholder="Enter your company name"
                                class="form-input"
                                <?= ($old['account_type'] ?? 'individual') === 'company' ? 'required' : '' ?>>
                        </div>
                    </div>

                    <!-- Names -->
                    <div class="form-group">
                        <div class="form-row">
                            <div>
                                <label for="first_name" class="form-label">First Name <span class="form-label-required">*</span></label>
                                <input id="first_name" name="first_name" type="text" required
                                    value="<?= htmlspecialchars($old['first_name'] ?? '') ?>"
                                    placeholder="Enter your first name" class="form-input">
                            </div>
                            <div>
                                <label for="last_name" class="form-label">Last Name <span class="form-label-required">*</span></label>
                                <input id="last_name" name="last_name" type="text" required
                                    value="<?= htmlspecialchars($old['last_name'] ?? '') ?>"
                                    placeholder="Enter your last name" class="form-input">
                            </div>
                        </div>
                    </div>

                    <!-- Email -->
                    <div class="form-group">
                        <label for="email" class="form-label">Email Address <span class="form-label-required">*</span></label>
                        <input id="email" name="email" type="email" required
                            value="<?= htmlspecialchars($old['email'] ?? '') ?>"
                            placeholder="Enter your email address" class="form-input">
                        <div class="form-hint">We'll send a verification email to this address</div>
                    </div>

                    <!-- Password -->
                    <div class="form-group">
                        <label for="password" class="form-label">Password <span class="form-label-required">*</span></label>
                        <input id="password" name="password" type="password" required
                            placeholder="Create a secure password" class="form-input">
                        <div class="password-strength">
                            <div class="strength-bar">
                                <div class="strength-fill" id="password-strength-bar"></div>
                            </div>
                            <div class="strength-text" id="password-strength-text">Password strength: —</div>
                        </div>
                        <div class="form-hint">Minimum 8 characters with letters and numbers</div>
                    </div>

                    <!-- Confirm -->
                    <div class="form-group">
                        <label for="confirm_password" class="form-label">Confirm Password <span class="form-label-required">*</span></label>
                        <input id="confirm_password" name="confirm_password" type="password" required
                            placeholder="Confirm your password" class="form-input">
                    </div>

                    <!-- Terms -->
                    <div class="checkbox-group">
                        <input id="agree_terms" name="agree_terms" type="checkbox" class="checkbox-input" <?= isset($old['agree_terms']) ? 'checked' : '' ?> required>
                        <label for="agree_terms" class="checkbox-label">
                            I agree to the <a href="<?= $baseUrl ?? '' ?>/terms" class="auth-link-primary">Terms of Service</a>
                            and <a href="<?= $baseUrl ?? '' ?>/privacy" class="auth-link-primary">Privacy Policy</a>
                        </label>
                    </div>

                    <button type="submit" class="auth-button">Create Account</button>

                    <div class="auth-links">
                        <p class="auth-text-muted">Already have an account? <a href="<?= $baseUrl ?? '' ?>/login" class="auth-link-primary">Sign in</a></p>
                    </div>
                </form>
            </div>
        </div>
    </main>

    <!-- OUR footer -->
    <footer class="auth-site-footer">
        <div class="auth-footer-wrap">
            <div class="auth-footer-grid">
                <div>
                    <div class="auth-footer-brand">
                        <span class="auth-brand-badge">🧠</span><span>LeadIntelligence AI</span>
                    </div>
                    <p style="margin:0; line-height:1.55;">Streamline your lead management with AI-powered tools that help you capture, track, and convert leads efficiently.</p>
                </div>
                <div class="auth-footer-col">
                    <h4>Product</h4>
                    <a href="<?= $baseUrl ?? '' ?>/#features">Features</a>
                    <a href="<?= $baseUrl ?? '' ?>/#pricing">Pricing</a>
                    <a href="<?= $baseUrl ?? '' ?>/integrations">Integrations</a>
                </div>
                <div class="auth-footer-col">
                    <h4>Company</h4>
                    <a href="<?= $baseUrl ?? '' ?>/about">About</a>
                    <a href="<?= $baseUrl ?? '' ?>/blog">Blog</a>
                    <a href="<?= $baseUrl ?? '' ?>/careers">Careers</a>
                </div>
                <div class="auth-footer-col">
                    <h4>Support</h4>
                    <a href="<?= $baseUrl ?? '' ?>/docs">Documentation</a>
                    <a href="<?= $baseUrl ?? '' ?>/contact">Contact</a>
                    <a href="<?= $baseUrl ?? '' ?>/status">Status</a>
                </div>
            </div>
            <div class="auth-footer-bottom">© <?= date('Y') ?> LeadIntelligence AI. All rights reserved.</div>
        </div>
    </footer>

    <script>
        // Account type toggle + company block
        document.querySelectorAll('.account-type-card').forEach(card => {
            card.addEventListener('click', () => {
                document.querySelectorAll('.account-type-card').forEach(c => c.classList.remove('selected'));
                card.classList.add('selected');
                const radio = card.querySelector('.account-type-radio');
                radio.checked = true;

                const isCompany = radio.value === 'company';
                const fld = document.getElementById('company-field');
                const req = document.getElementById('company-required');
                const inp = document.getElementById('company_name');
                fld.classList.toggle('active', isCompany);
                inp.required = isCompany;
                req.style.display = isCompany ? 'inline' : 'none';
                if (!isCompany) inp.value = '';
            });
        });
        (function initCompany() {
            const cur = document.querySelector('input[name="account_type"]:checked');
            if (!cur) return;
            const isCompany = cur.value === 'company';
            const fld = document.getElementById('company-field');
            const req = document.getElementById('company-required');
            const inp = document.getElementById('company_name');
            fld.classList.toggle('active', isCompany);
            inp.required = isCompany;
            req.style.display = isCompany ? 'inline' : 'none';
        })();

        // Password strength
        (function() {
            const pw = document.getElementById('password');
            const bar = document.getElementById('password-strength-bar');
            const txt = document.getElementById('password-strength-text');
            if (!pw || !bar || !txt) return;
            pw.addEventListener('input', () => {
                const v = pw.value;
                let s = 0;
                if (v.length >= 8) s += 20;
                if (v.length >= 12) s += 10;
                if (/[a-z]/.test(v)) s += 20;
                if (/[A-Z]/.test(v)) s += 20;
                if (/[0-9]/.test(v)) s += 20;
                if (/[^a-zA-Z0-9]/.test(v)) s += 10;
                s = Math.min(s, 100);
                bar.style.width = s + '%';
                if (s < 40) {
                    bar.className = 'strength-fill strength-weak';
                    txt.textContent = 'Password strength: Weak';
                } else if (s < 70) {
                    bar.className = 'strength-fill strength-medium';
                    txt.textContent = 'Password strength: Medium';
                } else {
                    bar.className = 'strength-fill strength-strong';
                    txt.textContent = 'Password strength: Strong';
                }
            });
        })();

        // Final guard for company required
        document.getElementById('registerForm')?.addEventListener('submit', (e) => {
            const type = document.querySelector('input[name="account_type"]:checked')?.value || 'individual';
            const company = document.getElementById('company_name');
            if (type === 'company' && !company.value.trim()) {
                e.preventDefault();
                alert('Please enter your company name for business accounts.');
                company.focus();
            }
        });
    </script>
</body>

</html>