<?php include VIEWS_PATH . '/layouts/auth-header.php'; ?>

<main class="auth-main">
    <div class="auth-container">
        <div class="auth-card forgot">
            <div class="auth-card-header">
                <h1 class="auth-title">Reset your password</h1>
                <p class="auth-subtitle">
                    Or <a href="<?= $baseUrl ?? '' ?>/login" class="auth-link-primary">sign in to your existing account</a>
                </p>
            </div>

            <?php if (isset($error)): ?>
                <div class="form-error">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <?php if (isset($success)): ?>
                <div class="form-success">
                    <?= htmlspecialchars($success) ?>
                </div>
            <?php endif; ?>

            <form class="auth-form" action="<?= $baseUrl ?? '' ?>/forgot-password" method="post">
                <div class="form-group">
                    <label for="email" class="form-label">
                        Email Address <span class="form-label-required">*</span>
                    </label>
                    <input id="email" name="email" type="email" required
                           placeholder="Enter your email address"
                           value="<?= htmlspecialchars($old['email'] ?? '') ?>"
                           class="form-input">
                    <div class="form-hint">We'll send a password reset link to this address</div>
                </div>

                <button type="submit" class="auth-button">
                    Send Reset Link
                </button>
            </form>

            <div class="auth-links">
                <p class="auth-text-muted">
                    Remember your password? 
                    <a href="<?= $baseUrl ?? '' ?>/login" class="auth-link-primary">Back to login</a>
                </p>
            </div>
        </div>
    </div>
</main>

<?php include VIEWS_PATH . '/layouts/auth-footer.php'; ?>